/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.graphql.core.scripting;

import graphql.ExecutionResult;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import javax.script.AbstractScriptEngine;
import javax.script.Bindings;
import javax.script.ScriptContext;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptException;
import org.apache.commons.io.IOUtils;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.graphql.core.engine.GraphQLResourceQuery;
import org.apache.sling.graphql.core.json.JsonSerializer;
import org.apache.sling.graphql.core.scripting.GraphQLScriptEngineFactory;

public class GraphQLScriptEngine
extends AbstractScriptEngine {
    private final GraphQLScriptEngineFactory factory;
    private final JsonSerializer jsonSerializer = new JsonSerializer();
    public static final int JSON_INDENT_SPACES = 2;

    public GraphQLScriptEngine(GraphQLScriptEngineFactory factory) {
        this.factory = factory;
    }

    @Override
    public Object eval(String script, ScriptContext context) throws ScriptException {
        return this.eval((Reader)new StringReader(script), context);
    }

    @Override
    public Object eval(Reader reader, ScriptContext context) throws ScriptException {
        try {
            GraphQLResourceQuery q = new GraphQLResourceQuery();
            Resource resource = (Resource)context.getBindings(100).get("resource");
            String[] selectors = this.getRequestSelectors(resource);
            ExecutionResult result = q.executeQuery(this.factory.getSchemaProviders(), this.factory.getdataFetcherSelector(), this.factory.getScalarsProvider(), resource, selectors, IOUtils.toString((Reader)reader), null);
            PrintWriter out = (PrintWriter)context.getBindings(100).get("out");
            this.jsonSerializer.sendJSON(out, result);
        }
        catch (Exception e) {
            throw new ScriptException(e);
        }
        return null;
    }

    @Override
    public Bindings createBindings() {
        return null;
    }

    @Override
    public ScriptEngineFactory getFactory() {
        return this.factory;
    }

    private String[] getRequestSelectors(Resource r) {
        String pathInfo;
        ArrayList result = new ArrayList();
        if (r != null && (pathInfo = r.getResourceMetadata().getResolutionPathInfo()) != null && pathInfo.startsWith(".")) {
            String[] parts = pathInfo.split("\\.");
            Arrays.stream(parts).limit(parts.length - 1).forEach(it -> result.add(it));
        }
        return result.toArray(new String[0]);
    }
}

