/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.graphql.core.scalars;

import graphql.language.ScalarTypeDefinition;
import graphql.schema.Coercing;
import graphql.schema.GraphQLScalarType;
import graphql.schema.idl.ScalarInfo;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.sling.graphql.api.SlingScalarConverter;
import org.apache.sling.graphql.core.engine.SlingGraphQLException;
import org.apache.sling.graphql.core.scalars.SlingCoercingWrapper;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;

@Component(service={SlingScalarsProvider.class}, property={"service.description=Apache Sling Scripting GraphQL Scalars Provider", "service.vendor=The Apache Software Foundation"})
public class SlingScalarsProvider {
    private BundleContext bundleContext;

    @Activate
    public void activate(BundleContext ctx) {
        this.bundleContext = ctx;
    }

    private GraphQLScalarType getScalar(String name) {
        if (ScalarInfo.STANDARD_SCALAR_DEFINITIONS.containsKey(name)) {
            return null;
        }
        Object converter = null;
        String filter = String.format("(%s=%s)", "name", name);
        ServiceReference[] refs = null;
        try {
            refs = this.bundleContext.getServiceReferences(SlingScalarConverter.class.getName(), filter);
        }
        catch (InvalidSyntaxException ise) {
            throw new SlingGraphQLException("Invalid OSGi filter syntax:" + filter);
        }
        if (refs != null) {
            if (refs.length > 1) {
                throw new SlingGraphQLException(String.format("Got %d services for %s, expected just one", refs.length, filter));
            }
            converter = (SlingScalarConverter)this.bundleContext.getService(refs[0]);
        }
        if (converter == null) {
            throw new SlingGraphQLException("SlingScalarConverter with name '" + name + "' not found");
        }
        return GraphQLScalarType.newScalar().name(name).description(converter.toString()).coercing((Coercing)new SlingCoercingWrapper((SlingScalarConverter<Object, Object>)converter)).build();
    }

    public Iterable<GraphQLScalarType> getCustomScalars(Map<String, ScalarTypeDefinition> schemaScalars) {
        return schemaScalars.keySet().stream().map(this::getScalar).filter(it -> it != null).collect(Collectors.toList());
    }
}

