/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.graphql.core.engine;

import graphql.ExecutionInput;
import graphql.ExecutionResult;
import graphql.GraphQL;
import graphql.language.Argument;
import graphql.language.Directive;
import graphql.language.FieldDefinition;
import graphql.language.ObjectTypeDefinition;
import graphql.language.StringValue;
import graphql.schema.DataFetcher;
import graphql.schema.GraphQLScalarType;
import graphql.schema.GraphQLSchema;
import graphql.schema.idl.RuntimeWiring;
import graphql.schema.idl.SchemaGenerator;
import graphql.schema.idl.SchemaParser;
import graphql.schema.idl.TypeDefinitionRegistry;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.script.ScriptException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.graphql.api.SchemaProvider;
import org.apache.sling.graphql.api.SlingDataFetcher;
import org.apache.sling.graphql.core.engine.SlingDataFetcherSelector;
import org.apache.sling.graphql.core.engine.SlingDataFetcherWrapper;
import org.apache.sling.graphql.core.scalars.SlingScalarsProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphQLResourceQuery {
    public static final String FETCHER_DIRECTIVE = "fetcher";
    public static final String FETCHER_NAME = "name";
    public static final String FETCHER_OPTIONS = "options";
    public static final String FETCHER_SOURCE = "source";
    private static final Pattern FETCHER_NAME_PATTERN = Pattern.compile("\\w+(/\\w+)+");
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    public ExecutionResult executeQuery(SchemaProvider schemaProvider, SlingDataFetcherSelector fetchersSelector, SlingScalarsProvider scalarsProvider, Resource r, String[] requestSelectors, String query, Map<String, Object> variables) throws ScriptException {
        if (r == null) {
            throw new ScriptException("Resource is null");
        }
        if (query == null) {
            throw new ScriptException("Query is null");
        }
        if (schemaProvider == null) {
            throw new ScriptException("SchemaProvider is null");
        }
        if (fetchersSelector == null) {
            throw new ScriptException("DataFetcherSelector is null");
        }
        if (variables == null) {
            variables = Collections.emptyMap();
        }
        String schemaDef = null;
        try {
            schemaDef = schemaProvider.getSchema(r, requestSelectors);
        }
        catch (Exception e) {
            ScriptException up = new ScriptException("Schema provider failed");
            up.initCause(e);
            this.log.info("Schema provider Exception", (Throwable)up);
            throw up;
        }
        this.log.debug("Resource {} maps to GQL schema {}", (Object)r.getPath(), (Object)schemaDef);
        try {
            GraphQLSchema schema = this.buildSchema(schemaDef, fetchersSelector, scalarsProvider, r);
            GraphQL graphQL = GraphQL.newGraphQL((GraphQLSchema)schema).build();
            this.log.debug("Executing query\n[{}]\nat [{}] with variables [{}]", new Object[]{query, r.getPath(), variables});
            ExecutionInput ei = ExecutionInput.newExecutionInput().query(query).variables(variables).build();
            ExecutionResult result = graphQL.execute(ei);
            this.log.debug("ExecutionResult.isDataPresent={}", (Object)result.isDataPresent());
            return result;
        }
        catch (Exception e) {
            ScriptException up = new ScriptException(String.format("Query failed for Resource %s: schema=%s, query=%s", r.getPath(), schemaDef, query));
            up.initCause(e);
            this.log.info("GraphQL Query Exception", (Throwable)up);
            throw up;
        }
    }

    private GraphQLSchema buildSchema(String sdl, SlingDataFetcherSelector fetchers, SlingScalarsProvider scalarsProvider, Resource currentResource) throws IOException {
        TypeDefinitionRegistry typeRegistry = new SchemaParser().parse(sdl);
        Iterable<GraphQLScalarType> scalars = scalarsProvider.getCustomScalars(typeRegistry.scalars());
        RuntimeWiring runtimeWiring = this.buildWiring(typeRegistry, fetchers, scalars, currentResource);
        SchemaGenerator schemaGenerator = new SchemaGenerator();
        return schemaGenerator.makeExecutableSchema(typeRegistry, runtimeWiring);
    }

    private RuntimeWiring buildWiring(TypeDefinitionRegistry typeRegistry, SlingDataFetcherSelector fetchers, Iterable<GraphQLScalarType> scalars, Resource r) throws IOException {
        List types = typeRegistry.getTypes(ObjectTypeDefinition.class);
        RuntimeWiring.Builder builder = RuntimeWiring.newRuntimeWiring();
        for (ObjectTypeDefinition type : types) {
            builder.type(type.getName(), typeWiring -> {
                for (FieldDefinition field : type.getFieldDefinitions()) {
                    try {
                        DataFetcher<Object> fetcher = this.getDataFetcher(field, fetchers, r);
                        if (fetcher == null) continue;
                        typeWiring.dataFetcher(field.getName(), fetcher);
                    }
                    catch (IOException e) {
                        throw new RuntimeException("Exception while building wiring", e);
                    }
                }
                return typeWiring;
            });
        }
        scalars.forEach(arg_0 -> ((RuntimeWiring.Builder)builder).scalar(arg_0));
        return builder.build();
    }

    private String getDirectiveArgumentValue(Directive d, String name) {
        Argument a = d.getArgument(name);
        if (a != null && a.getValue() instanceof StringValue) {
            return ((StringValue)a.getValue()).getValue();
        }
        return null;
    }

    static String validateFetcherName(String name) throws IOException {
        if (name == null) {
            throw new IOException("name cannot be null");
        }
        if (!FETCHER_NAME_PATTERN.matcher(name).matches()) {
            throw new IOException(String.format("Invalid fetcher name %s, does not match %s", name, FETCHER_NAME_PATTERN));
        }
        return name;
    }

    private DataFetcher<Object> getDataFetcher(FieldDefinition field, SlingDataFetcherSelector fetchers, Resource currentResource) throws IOException {
        SlingDataFetcherWrapper<Object> result = null;
        Directive d = field.getDirective(FETCHER_DIRECTIVE);
        if (d != null) {
            String name = GraphQLResourceQuery.validateFetcherName(this.getDirectiveArgumentValue(d, FETCHER_NAME));
            String options = this.getDirectiveArgumentValue(d, FETCHER_OPTIONS);
            String source = this.getDirectiveArgumentValue(d, FETCHER_SOURCE);
            SlingDataFetcher<Object> f = fetchers.getSlingFetcher(name);
            if (f != null) {
                result = new SlingDataFetcherWrapper<Object>(f, currentResource, options, source);
            }
        }
        return result;
    }
}

