/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.graphql.core.engine;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.sling.graphql.api.engine.ValidationResult;
import org.jetbrains.annotations.NotNull;

public class DefaultValidationResult
implements ValidationResult {
    private final boolean isValid;
    private final List<String> errors;

    private DefaultValidationResult(boolean isValid, List<String> errors) {
        this.isValid = isValid;
        this.errors = errors;
    }

    @Override
    public boolean isValid() {
        return this.isValid;
    }

    @Override
    @NotNull
    public List<String> getErrors() {
        return Collections.unmodifiableList(this.errors);
    }

    static class Builder {
        private boolean isValid;
        private List<String> errors = new ArrayList<String>();

        private Builder() {
        }

        Builder withValidFlag(boolean isValid) {
            this.isValid = isValid;
            return this;
        }

        Builder withErrorMessage(@NotNull String message) {
            this.errors.add(message);
            return this;
        }

        ValidationResult build() {
            return new DefaultValidationResult(this.isValid, this.errors);
        }

        static Builder newBuilder() {
            return new Builder();
        }
    }
}

