/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.graphql.core.scripting;

import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import javax.json.Json;
import javax.json.JsonStructure;
import javax.json.JsonWriter;
import javax.script.AbstractScriptEngine;
import javax.script.Bindings;
import javax.script.ScriptContext;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptException;
import org.apache.commons.io.IOUtils;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.graphql.core.scripting.GraphQLScriptEngineFactory;

public class GraphQLScriptEngine
extends AbstractScriptEngine {
    private final GraphQLScriptEngineFactory factory;

    public GraphQLScriptEngine(GraphQLScriptEngineFactory factory) {
        this.factory = factory;
    }

    @Override
    public Object eval(String script, ScriptContext context) throws ScriptException {
        return this.eval((Reader)new StringReader(script), context);
    }

    @Override
    public Object eval(Reader reader, ScriptContext context) throws ScriptException {
        try (JsonWriter writer = Json.createWriter((Writer)((PrintWriter)context.getBindings(100).get("out")));){
            Resource resource = (Resource)context.getBindings(100).get("resource");
            String[] selectors = this.getRequestSelectors(resource);
            Map<String, Object> executionResult = this.factory.getQueryExecutor().execute(IOUtils.toString((Reader)reader), Collections.emptyMap(), resource, selectors);
            writer.write((JsonStructure)Json.createObjectBuilder(executionResult).build().asJsonObject());
        }
        catch (Exception e) {
            throw new ScriptException(e);
        }
        return null;
    }

    @Override
    public Bindings createBindings() {
        return null;
    }

    @Override
    public ScriptEngineFactory getFactory() {
        return this.factory;
    }

    private String[] getRequestSelectors(Resource r) {
        String pathInfo;
        ArrayList result = new ArrayList();
        if (r != null && (pathInfo = r.getResourceMetadata().getResolutionPathInfo()) != null && pathInfo.startsWith(".")) {
            String[] parts = pathInfo.split("\\.");
            Arrays.stream(parts).limit(parts.length - 1).forEach(result::add);
        }
        return result.toArray(new String[0]);
    }
}

