/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.graphql.core.engine;

import graphql.com.google.common.collect.ImmutableList;
import graphql.schema.DataFetchingFieldSelectionSet;
import graphql.schema.SelectedField;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.MultiValuedMap;
import org.apache.commons.collections4.multimap.HashSetValuedHashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SelectedFieldWrapper
implements org.apache.sling.graphql.api.SelectedField {
    private final String name;
    private final String fullyQualifiedName;
    private final String qualifiedName;
    private final boolean conditional;
    private final int level;
    private final String alias;
    private final String resultKey;
    private final List<String> objectTypeNames;
    private final MultiValuedMap<String, org.apache.sling.graphql.api.SelectedField> subFieldMap = new HashSetValuedHashMap();
    private final Map<String, org.apache.sling.graphql.api.SelectedField> subFQNFieldMap = new HashMap<String, org.apache.sling.graphql.api.SelectedField>();
    private final List<org.apache.sling.graphql.api.SelectedField> subFields;

    public SelectedFieldWrapper(SelectedField selectedField) {
        this.name = selectedField.getName();
        this.qualifiedName = selectedField.getQualifiedName();
        this.fullyQualifiedName = selectedField.getFullyQualifiedName();
        this.objectTypeNames = selectedField.getObjectTypeNames() == null ? Collections.emptyList() : new ArrayList(selectedField.getObjectTypeNames());
        this.conditional = selectedField.isConditional();
        this.level = selectedField.getLevel();
        this.alias = selectedField.getAlias();
        this.resultKey = selectedField.getResultKey();
        DataFetchingFieldSelectionSet selectionSet = selectedField.getSelectionSet();
        if (selectionSet != null) {
            selectionSet.getImmediateFields().forEach(sf -> {
                SelectedFieldWrapper selectedChildField = new SelectedFieldWrapper((SelectedField)sf);
                this.subFieldMap.put((Object)sf.getName(), (Object)selectedChildField);
                this.subFQNFieldMap.put(sf.getFullyQualifiedName(), selectedChildField);
            });
        }
        this.subFields = new ArrayList<org.apache.sling.graphql.api.SelectedField>(this.subFQNFieldMap.values());
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    @Nullable
    public String getQualifiedName() {
        return this.qualifiedName;
    }

    @Override
    public String getFullyQualifiedName() {
        return this.fullyQualifiedName;
    }

    @Override
    public boolean isConditional() {
        return this.conditional;
    }

    @Override
    public int getLevel() {
        return this.level;
    }

    @Override
    public String getAlias() {
        return this.alias;
    }

    @Override
    public String getResultKey() {
        return this.resultKey;
    }

    @Override
    @NotNull
    public List<org.apache.sling.graphql.api.SelectedField> getSubSelectedFields() {
        return this.subFields;
    }

    @Override
    @NotNull
    public Collection<org.apache.sling.graphql.api.SelectedField> getSubSelectedFieldByName(@NotNull String name) {
        return this.subFieldMap.get((Object)name);
    }

    @Override
    @Nullable
    public org.apache.sling.graphql.api.SelectedField getFirstSubSelectedFieldByName(@NotNull String name) {
        Collection<org.apache.sling.graphql.api.SelectedField> fields = this.getSubSelectedFieldByName(name);
        return fields.isEmpty() ? null : fields.iterator().next();
    }

    @Override
    @Nullable
    public org.apache.sling.graphql.api.SelectedField getSubSelectedFieldByFQN(@NotNull String fullyQualifiedName) {
        return this.subFQNFieldMap.get(fullyQualifiedName);
    }

    @Override
    public boolean hasDuplicateFieldByName(@NotNull String name) {
        return this.subFieldMap.get((Object)name).size() > 1;
    }

    @Override
    public boolean hasSubSelectedFieldsByName(String ... name) {
        return Arrays.stream(name).anyMatch(arg_0 -> this.subFieldMap.containsKey(arg_0));
    }

    @Override
    public boolean hasSubSelectedFieldsByFQN(String ... fullyQualifiedName) {
        return Arrays.stream(fullyQualifiedName).anyMatch(this.subFQNFieldMap::containsKey);
    }

    @Override
    @Deprecated
    public org.apache.sling.graphql.api.SelectedField getSubSelectedField(@NotNull String name) {
        return name.indexOf(46) >= 0 ? this.getSubSelectedFieldByFQN(name) : this.getFirstSubSelectedFieldByName(name);
    }

    @Override
    @Deprecated
    public boolean hasSubSelectedFields(String ... name) {
        return name[0].indexOf(46) >= 0 ? Arrays.stream(name).anyMatch(this.subFQNFieldMap::containsKey) : Arrays.stream(name).anyMatch(arg_0 -> this.subFieldMap.containsKey(arg_0));
    }

    @Override
    @Deprecated
    public boolean isInline() {
        return false;
    }

    @Override
    @NotNull
    public List<String> getObjectTypeNames() {
        return ImmutableList.copyOf(this.objectTypeNames);
    }
}

