/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.graphql.core.servlet;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.Collections;
import java.util.Map;
import org.apache.commons.io.input.ReaderInputStream;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.graphql.core.json.JsonSerializer;

public class RequestParser {
    private static final String MIME_TYPE_JSON = "application/json";
    private String query;
    private Map<String, Object> variables;
    private final JsonSerializer jsonSerializer = new JsonSerializer();

    RequestParser(SlingHttpServletRequest request) throws IOException {
        this.parse(request);
    }

    private Map<String, Object> getInputJson(SlingHttpServletRequest req) throws IOException {
        return this.jsonSerializer.JSONtoMaps((InputStream)new ReaderInputStream((Reader)req.getReader()));
    }

    private void parse(SlingHttpServletRequest request) throws IOException {
        if (request.getMethod().equalsIgnoreCase("POST") && MIME_TYPE_JSON.equals(request.getContentType())) {
            Map<String, Object> requestJson = this.getInputJson(request);
            this.query = (String)requestJson.get("query");
            if (this.query != null) {
                this.query = this.query.replace("\\n", "\n");
            }
            this.variables = (Map)requestJson.get("variables");
        }
        if (this.query == null) {
            this.query = request.getParameter("query");
        }
        if (this.variables == null) {
            this.variables = Collections.emptyMap();
        }
    }

    public String getQuery() {
        return this.query;
    }

    public Map<String, Object> getVariables() {
        return this.variables;
    }
}

