/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.graphql.core.engine;

import java.io.IOException;
import org.apache.sling.graphql.api.SlingDataFetcher;
import org.apache.sling.graphql.core.engine.ScriptedDataFetcherProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={SlingDataFetcherSelector.class})
public class SlingDataFetcherSelector {
    public static final String RESERVED_NAME_PREFIX = "sling/";
    public static final String RESERVED_PACKAGE_PREFIX = "org.apache.sling.";
    private BundleContext bundleContext;
    @Reference
    private ScriptedDataFetcherProvider scriptedDataFetcherProvider;

    @Activate
    public void activate(BundleContext ctx) {
        this.bundleContext = ctx;
    }

    private SlingDataFetcher<Object> getOsgiServiceFetcher(@NotNull String name) throws IOException {
        SlingDataFetcher result = null;
        String filter = String.format("(%s=%s)", "name", name);
        ServiceReference[] refs = null;
        try {
            refs = this.bundleContext.getServiceReferences(SlingDataFetcher.class.getName(), filter);
        }
        catch (InvalidSyntaxException ise) {
            throw new IOException("Invalid OSGi filter syntax", ise);
        }
        if (refs != null) {
            if (refs.length > 1) {
                throw new IOException(String.format("Got %d services for %s, expected just one", refs.length, filter));
            }
            result = (SlingDataFetcher)this.bundleContext.getService(refs[0]);
            this.validateResult(name, result);
        }
        return result;
    }

    private void validateResult(String name, SlingDataFetcher<?> fetcher) throws IOException {
        if (name.startsWith(RESERVED_NAME_PREFIX)) {
            String className = fetcher.getClass().getName();
            if (!fetcher.getClass().getName().startsWith(RESERVED_PACKAGE_PREFIX)) {
                throw new IOException(String.format("Invalid SlingDataFetcher %s: fetcher names starting with '%s' are reserved for Apache Sling Java packages", className, RESERVED_NAME_PREFIX));
            }
        }
    }

    @Nullable
    public SlingDataFetcher<Object> getSlingFetcher(@NotNull String name) throws IOException {
        SlingDataFetcher<Object> result = this.getOsgiServiceFetcher(name);
        if (result == null) {
            result = this.scriptedDataFetcherProvider.getDataFetcher(name);
        }
        return result;
    }
}

