/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.graphql.core.servlet;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Collections;
import java.util.Map;
import javax.json.Json;
import javax.json.JsonObject;
import javax.json.JsonReader;
import javax.json.JsonValue;
import org.apache.johnzon.mapper.Mapper;
import org.apache.johnzon.mapper.MapperBuilder;
import org.apache.sling.api.SlingHttpServletRequest;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class QueryParser {
    private static final String MIME_TYPE_JSON = "application/json";
    private static final String JSON_KEY_QUERY = "query";
    private static final String JSON_KEY_VARIABLES = "variables";
    private static final Mapper MAPPER = new MapperBuilder().build();

    private QueryParser() {
    }

    private static boolean isJsonContentType(SlingHttpServletRequest request) {
        String contentType = request.getContentType();
        if (MIME_TYPE_JSON.equals(contentType)) {
            return true;
        }
        if (contentType != null) {
            String[] parts = contentType.split(";");
            return MIME_TYPE_JSON.equals(parts[0].trim());
        }
        return false;
    }

    @Nullable
    public static Result fromRequest(@NotNull SlingHttpServletRequest request) throws IOException {
        String query = null;
        Map variables = null;
        if (request.getMethod().equalsIgnoreCase("POST") && QueryParser.isJsonContentType(request)) {
            try (JsonReader reader = Json.createReader((Reader)request.getReader());){
                JsonObject input = reader.readObject();
                query = input.getString(JSON_KEY_QUERY);
                query = query.replace("\\n", "\n");
                if (input.containsKey((Object)JSON_KEY_VARIABLES)) {
                    variables = (Map)MAPPER.readObject((JsonValue)input.get((Object)JSON_KEY_VARIABLES), Map.class);
                }
            }
        }
        if (query == null) {
            query = request.getParameter(JSON_KEY_QUERY);
        }
        if (variables == null) {
            variables = Collections.emptyMap();
        }
        if (query != null) {
            return new Result(query, variables);
        }
        return null;
    }

    public static Result fromJSON(String json) throws IOException {
        Throwable throwable = null;
        try (JsonReader reader = Json.createReader((Reader)new StringReader(json));){
            JsonObject jsonInput = reader.readObject();
            String query = jsonInput.getString(JSON_KEY_QUERY);
            if (query != null) {
                Map variables = null;
                variables = jsonInput.containsKey((Object)JSON_KEY_VARIABLES) ? (Map)MAPPER.readObject((JsonValue)jsonInput.get((Object)JSON_KEY_VARIABLES), Map.class) : Collections.emptyMap();
                Result result = new Result(query, variables);
                return result;
            }
            try {
                throw new IOException("The provided JSON structure does not contain a query.");
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    static class Result {
        private final String query;
        private final Map<String, Object> variables;

        Result(String query, Map<String, Object> variables) {
            this.query = query;
            this.variables = variables;
        }

        @NotNull
        public String getQuery() {
            return this.query;
        }

        @NotNull
        public Map<String, Object> getVariables() {
            return this.variables;
        }
    }
}

