/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.graphql.core.engine;

import graphql.language.Field;
import graphql.language.InlineFragment;
import graphql.language.Selection;
import graphql.language.SelectionSet;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.sling.graphql.api.SelectedField;

public class SelectedFieldWrapper
implements SelectedField {
    private String name;
    private boolean isInline;
    private Map<String, SelectedField> subFieldMap = new HashMap<String, SelectedField>();
    private List<SelectedField> subFields;

    public SelectedFieldWrapper(Selection selection) {
        SelectionSet selectionSet = null;
        if (selection instanceof InlineFragment) {
            InlineFragment inline = (InlineFragment)selection;
            this.name = inline.getTypeCondition().getName();
            this.isInline = true;
            selectionSet = inline.getSelectionSet();
        }
        if (selection instanceof Field) {
            Field subField = (Field)selection;
            this.name = subField.getName();
            selectionSet = subField.getSelectionSet();
        }
        if (selectionSet != null) {
            selectionSet.getSelections().forEach(s -> {
                SelectedFieldWrapper wrappedField = new SelectedFieldWrapper((Selection)s);
                this.subFieldMap.put(wrappedField.getName(), wrappedField);
            });
        }
        this.subFields = this.subFieldMap.values().stream().collect(Collectors.toList());
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public List<SelectedField> getSubSelectedFields() {
        return this.subFields;
    }

    @Override
    public SelectedField getSubSelectedField(String name) {
        return this.subFieldMap.get(name);
    }

    @Override
    public boolean hasSubSelectedFields(String ... name) {
        return Arrays.stream(name).anyMatch(this.subFieldMap::containsKey);
    }

    @Override
    public boolean isInline() {
        return this.isInline;
    }
}

