/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.contentparser.json.internal;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonNumber;
import javax.json.JsonObject;
import javax.json.JsonReader;
import javax.json.JsonReaderFactory;
import javax.json.JsonString;
import javax.json.JsonValue;
import javax.json.stream.JsonParsingException;
import org.apache.commons.io.IOUtils;
import org.apache.sling.contentparser.api.ContentHandler;
import org.apache.sling.contentparser.api.ContentParser;
import org.apache.sling.contentparser.api.ParserHelper;
import org.apache.sling.contentparser.api.ParserOptions;
import org.apache.sling.contentparser.json.JSONParserFeature;
import org.apache.sling.contentparser.json.JSONParserOptions;
import org.apache.sling.contentparser.json.internal.JSONTicksConverter;
import org.osgi.service.component.annotations.Component;

@Component(property={"org.apache.sling.contentparser.content_type=json"})
public class JSONContentParser
implements ContentParser {
    private static final String JOHNZON_SUPPORT_COMMENTS = "org.apache.johnzon.supports-comments";

    @Override
    public void parse(ContentHandler handler, InputStream is, ParserOptions parserOptions) throws IOException {
        Map<String, Boolean> jsonReaderFactoryConfiguration;
        boolean supportComments;
        boolean jsonQuoteTicks;
        if (parserOptions instanceof JSONParserOptions) {
            JSONParserOptions jsonParserOptions = (JSONParserOptions)parserOptions;
            jsonQuoteTicks = jsonParserOptions.getFeatures().contains((Object)JSONParserFeature.QUOTE_TICK);
            supportComments = jsonParserOptions.getFeatures().contains((Object)JSONParserFeature.COMMENTS);
        } else {
            jsonQuoteTicks = false;
            supportComments = false;
        }
        if (supportComments) {
            jsonReaderFactoryConfiguration = new HashMap();
            jsonReaderFactoryConfiguration.put(JOHNZON_SUPPORT_COMMENTS, true);
        } else {
            jsonReaderFactoryConfiguration = Collections.emptyMap();
        }
        JsonReaderFactory jsonReaderFactory = Json.createReaderFactory(jsonReaderFactoryConfiguration);
        JsonObject jsonObject = jsonQuoteTicks ? this.toJsonObjectWithJsonTicks(jsonReaderFactory, is) : this.toJsonObject(jsonReaderFactory, is);
        this.parse(handler, jsonObject, parserOptions, "/");
    }

    private JsonObject toJsonObject(JsonReaderFactory jsonReaderFactory, InputStream is) throws IOException {
        JsonObject jsonObject;
        block8: {
            JsonReader reader = jsonReaderFactory.createReader(is);
            try {
                jsonObject = reader.readObject();
                if (reader == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (JsonParsingException ex) {
                    throw new IOException("Error parsing JSON content.", ex);
                }
            }
            reader.close();
        }
        return jsonObject;
    }

    private JsonObject toJsonObjectWithJsonTicks(JsonReaderFactory jsonReaderFactory, InputStream is) throws IOException {
        JsonObject jsonObject;
        block8: {
            String jsonString = IOUtils.toString((InputStream)is, (Charset)StandardCharsets.UTF_8);
            jsonString = JSONTicksConverter.tickToDoubleQuote(jsonString);
            JsonReader reader = jsonReaderFactory.createReader((Reader)new StringReader(jsonString));
            try {
                jsonObject = reader.readObject();
                if (reader == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (JsonParsingException ex) {
                    throw new IOException("Error parsing JSON content.", ex);
                }
            }
            reader.close();
        }
        return jsonObject;
    }

    private void parse(ContentHandler handler, JsonObject object, ParserOptions parserOptions, String path) throws IOException {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        LinkedHashMap<String, JsonObject> children = new LinkedHashMap<String, JsonObject>();
        for (Map.Entry entry : object.entrySet()) {
            String childName = (String)entry.getKey();
            Object value = null;
            boolean ignore = false;
            try {
                value = this.convertValue(parserOptions, (JsonValue)entry.getValue());
            }
            catch (IllegalArgumentException ex) {
                if (parserOptions.getIgnoreResourceNames().contains(childName) || parserOptions.getIgnorePropertyNames().contains(this.removePrefixFromPropertyName(parserOptions.getRemovePropertyNamePrefixes(), childName))) {
                    ignore = true;
                }
                throw new IOException(ex);
            }
            boolean isResource = value instanceof JsonObject;
            if (!ignore) {
                if (isResource) {
                    ignore = parserOptions.getIgnoreResourceNames().contains(childName);
                } else {
                    for (String prefix : parserOptions.getRemovePropertyNamePrefixes()) {
                        if (!childName.startsWith(prefix)) continue;
                        childName = childName.substring(prefix.length());
                        break;
                    }
                    ignore = parserOptions.getIgnorePropertyNames().contains(childName);
                }
            }
            if (ignore) continue;
            if (isResource) {
                children.put(childName, (JsonObject)value);
                continue;
            }
            properties.put(childName, value);
        }
        String defaultPrimaryType = parserOptions.getDefaultPrimaryType();
        if (defaultPrimaryType != null && !properties.containsKey("jcr:primaryType")) {
            properties.put("jcr:primaryType", defaultPrimaryType);
        }
        handler.resource(path, properties);
        for (Map.Entry entry : children.entrySet()) {
            String childPath = path.endsWith("/") ? path + (String)entry.getKey() : path + "/" + (String)entry.getKey();
            this.parse(handler, (JsonObject)entry.getValue(), parserOptions, childPath);
        }
    }

    private Object convertValue(ParserOptions parserOptions, JsonValue value) {
        switch (value.getValueType()) {
            case STRING: {
                Calendar calendar;
                String stringValue = ((JsonString)value).getString();
                if (parserOptions.isDetectCalendarValues() && (calendar = ParserHelper.parseDate(stringValue)) != null) {
                    return calendar;
                }
                return stringValue;
            }
            case NUMBER: {
                JsonNumber numberValue = (JsonNumber)value;
                if (numberValue.isIntegral()) {
                    return numberValue.longValue();
                }
                return numberValue.bigDecimalValue();
            }
            case TRUE: {
                return true;
            }
            case FALSE: {
                return false;
            }
            case NULL: {
                return null;
            }
            case ARRAY: {
                JsonArray arrayValue = (JsonArray)value;
                Object[] values = new Object[arrayValue.size()];
                for (int i = 0; i < values.length; ++i) {
                    values[i] = this.convertValue(parserOptions, (JsonValue)arrayValue.get(i));
                }
                return ParserHelper.convertSingleTypeArray(values);
            }
            case OBJECT: {
                return value;
            }
        }
        throw new IllegalArgumentException("Unexpected JSON value type: " + value.getValueType());
    }

    private String removePrefixFromPropertyName(Set<String> prefixes, String propertyName) {
        for (String prefix : prefixes) {
            if (!propertyName.startsWith(prefix)) continue;
            return propertyName.substring(prefix.length());
        }
        return propertyName;
    }
}

