/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.fsprovider.internal.mapper;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import org.apache.commons.collections4.IteratorUtils;
import org.apache.commons.collections4.Transformer;
import org.apache.commons.lang3.StringUtils;
import org.apache.jackrabbit.vault.fs.api.WorkspaceFilter;
import org.apache.jackrabbit.vault.fs.config.ConfigurationException;
import org.apache.jackrabbit.vault.fs.config.DefaultWorkspaceFilter;
import org.apache.jackrabbit.vault.util.PlatformNameFormat;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.fsprovider.internal.FileStatCache;
import org.apache.sling.fsprovider.internal.FsResourceMapper;
import org.apache.sling.fsprovider.internal.mapper.ContentFile;
import org.apache.sling.fsprovider.internal.mapper.ContentFileResource;
import org.apache.sling.fsprovider.internal.mapper.FileNameComparator;
import org.apache.sling.fsprovider.internal.mapper.FileResource;
import org.apache.sling.fsprovider.internal.parser.ContentElement;
import org.apache.sling.fsprovider.internal.parser.ContentFileCache;
import org.apache.sling.fsprovider.internal.parser.ContentFileTypes;
import org.apache.sling.jcr.contentparser.ContentType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FileVaultResourceMapper
implements FsResourceMapper {
    private static final String DOT_CONTENT_XML_SUFFIX = "/.content.xml";
    private static final String DOT_DIR = ".dir";
    private static final String DOT_DIR_SUFFIX = "/.dir";
    private final File providerFile;
    private final File filterXmlFile;
    private final ContentFileCache contentFileCache;
    private FileStatCache fileStatCache;
    private final WorkspaceFilter workspaceFilter;
    private static final Logger log = LoggerFactory.getLogger(FileVaultResourceMapper.class);

    public FileVaultResourceMapper(File providerFile, File filterXmlFile, ContentFileCache contentFileCache, FileStatCache fileStatCache) {
        this.providerFile = providerFile;
        this.filterXmlFile = filterXmlFile;
        this.contentFileCache = contentFileCache;
        this.fileStatCache = fileStatCache;
        this.workspaceFilter = this.getWorkspaceFilter();
    }

    @Override
    public Resource getResource(ResourceResolver resolver, String resourcePath) {
        File file = this.getFile(resourcePath);
        if (file != null && this.fileStatCache.isFile(file)) {
            return new FileResource(resolver, resourcePath, file, this.fileStatCache);
        }
        ContentFile contentFile = this.getContentFile(resourcePath, null);
        if (contentFile != null) {
            return new ContentFileResource(resolver, contentFile);
        }
        if (file != null && this.fileStatCache.isDirectory(file)) {
            return new FileResource(resolver, resourcePath, file, this.fileStatCache);
        }
        return null;
    }

    @Override
    public Iterator<Resource> getChildren(final ResourceResolver resolver, Resource parent) {
        File parentFile;
        String parentPath = parent.getPath();
        LinkedHashSet<String> childPaths = new LinkedHashSet<String>();
        ContentFile parentContentFile = this.getContentFile(parentPath, null);
        if (parentContentFile != null) {
            Iterator<Map.Entry<String, ContentElement>> childMaps = parentContentFile.getChildren();
            while (childMaps.hasNext()) {
                Map.Entry<String, ContentElement> entry = childMaps.next();
                String childPath = parentPath + "/" + entry.getKey();
                if (!this.pathMatches(childPath)) continue;
                childPaths.add(childPath);
            }
        }
        if ((parentFile = this.getFile(parentPath)) != null && this.fileStatCache.isDirectory(parentFile)) {
            File[] files = parentFile.listFiles();
            Arrays.sort(files, FileNameComparator.INSTANCE);
            for (File childFile : files) {
                ContentFile contentFile;
                String childPath = parentPath + "/" + PlatformNameFormat.getRepositoryName((String)childFile.getName());
                File file = this.getFile(childPath);
                if (file != null && this.pathMatches(childPath) && !childPaths.contains(childPath)) {
                    childPaths.add(childPath);
                    continue;
                }
                if (!childPath.endsWith(DOT_CONTENT_XML_SUFFIX)) {
                    childPath = StringUtils.removeEnd((String)childPath, (String)ContentFileTypes.XML_SUFFIX);
                }
                if ((contentFile = this.getContentFile(childPath, null)) == null || !this.pathMatches(childPath) || childPaths.contains(childPath)) continue;
                childPaths.add(childPath);
            }
        }
        if (childPaths.isEmpty()) {
            return null;
        }
        return IteratorUtils.transformedIterator(childPaths.iterator(), (Transformer)new Transformer(){

            public Object transform(Object input) {
                String path = (String)input;
                return FileVaultResourceMapper.this.getResource(resolver, path);
            }
        });
    }

    private WorkspaceFilter getWorkspaceFilter() {
        if (this.filterXmlFile != null && this.filterXmlFile.exists()) {
            try {
                DefaultWorkspaceFilter workspaceFilter = new DefaultWorkspaceFilter();
                workspaceFilter.load(this.filterXmlFile);
                return workspaceFilter;
            }
            catch (IOException | ConfigurationException ex) {
                log.error("Unable to parse workspace filter: " + this.filterXmlFile.getPath(), ex);
            }
        } else {
            log.debug("Workspace filter not found: " + this.filterXmlFile.getPath());
        }
        return null;
    }

    public boolean pathMatches(String path) {
        if (StringUtils.endsWith((CharSequence)path, (CharSequence)DOT_DIR_SUFFIX) || StringUtils.endsWith((CharSequence)path, (CharSequence)DOT_CONTENT_XML_SUFFIX)) {
            return false;
        }
        if (this.workspaceFilter == null) {
            return true;
        }
        return this.workspaceFilter.contains(path);
    }

    private File getFile(String path) {
        if (StringUtils.endsWith((CharSequence)path, (CharSequence)DOT_CONTENT_XML_SUFFIX)) {
            return null;
        }
        File file = new File(this.providerFile, "." + PlatformNameFormat.getPlatformPath((String)path));
        if (this.fileStatCache.exists(file)) {
            if (StringUtils.endsWith((CharSequence)path, (CharSequence)ContentFileTypes.XML_SUFFIX) && !this.hasDotDirFile(file)) {
                return null;
            }
            return file;
        }
        return null;
    }

    private ContentFile getContentFile(String path, String subPath) {
        ContentFile contentFile;
        File file = new File(this.providerFile, "." + PlatformNameFormat.getPlatformPath((String)path) + DOT_CONTENT_XML_SUFFIX);
        if (this.fileStatCache.exists(file) && (contentFile = new ContentFile(file, path, subPath, this.contentFileCache, ContentType.JCR_XML)).hasContent()) {
            return contentFile;
        }
        file = new File(this.providerFile, "." + PlatformNameFormat.getPlatformPath((String)path) + ContentFileTypes.XML_SUFFIX);
        if (this.fileStatCache.exists(file) && !this.hasDotDirFile(file) && (contentFile = new ContentFile(file, path, subPath, this.contentFileCache, ContentType.JCR_XML)).hasContent()) {
            return contentFile;
        }
        String parentPath = ResourceUtil.getParent((String)path);
        if (parentPath == null) {
            return null;
        }
        String nextSubPath = path.substring(parentPath.length() + 1) + (subPath != null ? "/" + subPath : "");
        return this.getContentFile(parentPath, nextSubPath);
    }

    private boolean hasDotDirFile(File file) {
        File dotDir = new File(file.getPath() + DOT_DIR);
        return this.fileStatCache.isDirectory(dotDir);
    }
}

