/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.fsprovider.internal.mapper.valuemap;

import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import org.apache.sling.fsprovider.internal.mapper.valuemap.DateUtils;

final class ObjectConverter {
    private ObjectConverter() {
    }

    public static <T> T convert(Object obj, Class<T> type) {
        if (obj == null) {
            return null;
        }
        if (type.isAssignableFrom(obj.getClass())) {
            return (T)obj;
        }
        if (type.isArray()) {
            return (T)ObjectConverter.convertToArray(obj, type.getComponentType());
        }
        if (Calendar.class.isAssignableFrom(type) && obj instanceof Date) {
            return (T)DateUtils.toCalendar((Date)obj);
        }
        if (type == Date.class && obj instanceof Calendar) {
            return (T)DateUtils.toDate((Calendar)obj);
        }
        String result = ObjectConverter.getSingleValue(obj);
        if (result == null) {
            return null;
        }
        if (type == String.class) {
            return (T)result.toString();
        }
        if (type == Boolean.class) {
            if ("true".equalsIgnoreCase(result)) {
                return (T)Boolean.TRUE;
            }
            if ("false".equalsIgnoreCase(result)) {
                return (T)Boolean.FALSE;
            }
            return null;
        }
        try {
            if (type == Byte.class) {
                return (T)Byte.valueOf(Byte.parseByte(result));
            }
            if (type == Short.class) {
                return (T)Short.valueOf(Short.parseShort(result));
            }
            if (type == Integer.class) {
                return (T)Integer.valueOf(Integer.parseInt(result));
            }
            if (type == Long.class) {
                return (T)Long.valueOf(Long.parseLong(result));
            }
            if (type == Float.class) {
                return (T)Float.valueOf(Float.parseFloat(result));
            }
            if (type == Double.class) {
                return (T)Double.valueOf(Double.parseDouble(result));
            }
            if (type == BigDecimal.class) {
                return (T)new BigDecimal(result);
            }
        }
        catch (NumberFormatException e) {
            return null;
        }
        if (Calendar.class.isAssignableFrom(type)) {
            return (T)DateUtils.calendarFromString(result);
        }
        if (type == Date.class) {
            return (T)DateUtils.dateFromString(result);
        }
        return null;
    }

    private static String getSingleValue(Object obj) {
        String result = obj == null ? null : (obj.getClass().isArray() ? (Array.getLength(obj) == 0 ? null : ObjectConverter.getSingleValue(Array.get(obj, 0))) : (obj instanceof Calendar ? DateUtils.calendarToString((Calendar)obj) : (obj instanceof Date ? DateUtils.dateToString((Date)obj) : obj.toString())));
        return result;
    }

    private static <T> T[] convertToArray(Object obj, Class<T> type) {
        if (obj.getClass().isArray()) {
            ArrayList<T> resultList = new ArrayList<T>();
            for (int i = 0; i < Array.getLength(obj); ++i) {
                T singleValueResult = ObjectConverter.convert(Array.get(obj, i), type);
                if (singleValueResult == null) continue;
                resultList.add(singleValueResult);
            }
            return resultList.toArray((Object[])Array.newInstance(type, resultList.size()));
        }
        T singleValueResult = ObjectConverter.convert(obj, type);
        if (singleValueResult == null) {
            return (Object[])Array.newInstance(type, 0);
        }
        Object[] arrayResult = (Object[])Array.newInstance(type, 1);
        arrayResult[0] = singleValueResult;
        return arrayResult;
    }
}

