/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.fsprovider.internal.mapper;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import javax.jcr.Node;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.apache.sling.adapter.annotations.Adaptable;
import org.apache.sling.adapter.annotations.Adapter;
import org.apache.sling.api.resource.AbstractResource;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceMetadata;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.wrappers.DeepReadValueMapDecorator;
import org.apache.sling.fsprovider.internal.ContentFileExtensions;
import org.apache.sling.fsprovider.internal.FileStatCache;
import org.apache.sling.fsprovider.internal.mapper.ContentFile;
import org.apache.sling.fsprovider.internal.mapper.LazyModifiedDateResourceMetadata;
import org.apache.sling.fsprovider.internal.mapper.jcr.FsNode;
import org.apache.sling.fsprovider.internal.mapper.valuemap.ValueMapDecorator;
import org.apache.sling.fsprovider.internal.parser.ContentFileCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Adaptable(adaptableClass=Resource.class, adapters={@Adapter(value={File.class, URL.class}), @Adapter(condition="If the resource is an FsResource and is a readable file.", value={InputStream.class})})
public final class FileResource
extends AbstractResource {
    static final String RESOURCE_TYPE_FILE = "nt:file";
    static final String RESOURCE_TYPE_FOLDER = "nt:folder";
    private final ResourceResolver resolver;
    private final String resourcePath;
    private final File file;
    private ResourceMetadata metaData;
    private String resourceType;
    private String resourceSuperType;
    private ValueMap valueMap;
    private final ContentFileExtensions contentFileExtensions;
    private final ContentFileCache contentFileCache;
    private final FileStatCache fileStatCache;
    private static final Logger log = LoggerFactory.getLogger(FileResource.class);

    FileResource(ResourceResolver resolver, String resourcePath, File file, FileStatCache fileStatCache) {
        this(resolver, resourcePath, file, null, null, fileStatCache);
    }

    FileResource(ResourceResolver resolver, String resourcePath, File file, ContentFileExtensions contentFileExtensions, ContentFileCache contentFileCache, FileStatCache fileStatCache) {
        this.resolver = resolver;
        this.resourcePath = resourcePath;
        this.file = file;
        this.contentFileExtensions = contentFileExtensions;
        this.contentFileCache = contentFileCache;
        this.fileStatCache = fileStatCache;
    }

    public String getPath() {
        return this.resourcePath;
    }

    public ResourceMetadata getResourceMetadata() {
        if (this.metaData == null) {
            this.metaData = new LazyModifiedDateResourceMetadata(this.file);
            this.metaData.setContentLength(this.file.length());
            this.metaData.setResolutionPath(this.resourcePath);
            if (this.fileStatCache.isDirectory(this.file)) {
                this.metaData.put(":org.apache.sling.fsprovider.file.directory", (Object)Boolean.TRUE);
            }
        }
        return this.metaData;
    }

    public ResourceResolver getResourceResolver() {
        return this.resolver;
    }

    public String getResourceSuperType() {
        if (this.resourceSuperType == null) {
            this.resourceSuperType = (String)this.getValueMap().get("sling:resourceSuperType", String.class);
        }
        return this.resourceSuperType;
    }

    public String getResourceType() {
        if (this.resourceType == null) {
            ValueMap props = this.getValueMap();
            this.resourceType = (String)props.get("sling:resourceType", String.class);
            if (this.resourceType == null) {
                this.resourceType = (String)props.get("jcr:primaryType", String.class);
            }
        }
        return this.resourceType;
    }

    public <AdapterType> AdapterType adaptTo(Class<AdapterType> type) {
        if (type == File.class) {
            return (AdapterType)this.file;
        }
        if (type == InputStream.class) {
            if (this.fileStatCache.isFile(this.file) && this.file.canRead()) {
                try {
                    return (AdapterType)new FileInputStream(this.file);
                }
                catch (IOException ioe) {
                    log.info("adaptTo: Cannot open a stream on the file " + this.file, (Throwable)ioe);
                }
            } else {
                log.debug("adaptTo: File {} is not a readable file", (Object)this.file);
            }
        } else if (type == URL.class) {
            try {
                return (AdapterType)this.file.toURI().toURL();
            }
            catch (MalformedURLException mue) {
                log.info("adaptTo: Cannot convert the file path " + this.file + " to an URL", (Throwable)mue);
            }
        } else {
            ContentFile contentFile;
            if (type == ValueMap.class) {
                return (AdapterType)this.getValueMap();
            }
            if (type == Node.class && (contentFile = this.getNodeDescriptorContentFile()) != null) {
                return (AdapterType)new FsNode(contentFile, this.getResourceResolver());
            }
        }
        return (AdapterType)super.adaptTo(type);
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("path", (Object)this.resourcePath).append("file", (Object)this.file.getPath()).append("resourceType", (Object)this.getResourceType()).build();
    }

    public ValueMap getValueMap() {
        if (this.valueMap == null && this.fileStatCache.exists(this.file) && this.file.canRead()) {
            HashMap<String, Object> props = new HashMap<String, Object>();
            props.put("jcr:primaryType", this.fileStatCache.isFile(this.file) ? RESOURCE_TYPE_FILE : RESOURCE_TYPE_FOLDER);
            props.put("jcr:createdBy", "system");
            Calendar lastModifed = Calendar.getInstance();
            lastModifed.setTimeInMillis(this.file.lastModified());
            props.put("jcr:created", lastModifed);
            ContentFile contentFile = this.getNodeDescriptorContentFile();
            if (contentFile != null) {
                for (Map.Entry entry : contentFile.getValueMap().entrySet()) {
                    if (StringUtils.equals((CharSequence)((CharSequence)entry.getKey()), (CharSequence)"jcr:primaryType") && StringUtils.equals((CharSequence)((String)entry.getValue()), (CharSequence)"nt:unstructured")) continue;
                    props.put((String)entry.getKey(), entry.getValue());
                }
            }
            this.valueMap = new DeepReadValueMapDecorator((Resource)this, (ValueMap)new ValueMapDecorator(props));
        }
        return this.valueMap;
    }

    private ContentFile getNodeDescriptorContentFile() {
        if (this.contentFileExtensions == null || this.contentFileCache == null) {
            return null;
        }
        for (String fileNameSuffix : this.contentFileExtensions.getSuffixes()) {
            File fileWithSuffix = new File(this.file.getPath() + fileNameSuffix);
            if (!this.fileStatCache.exists(fileWithSuffix) || !fileWithSuffix.canRead()) continue;
            return new ContentFile(fileWithSuffix, this.resourcePath, null, this.contentFileCache);
        }
        return null;
    }
}

