/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.fileoptim.impl.servlets;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import org.apache.commons.io.IOUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.servlets.SlingSafeMethodsServlet;
import org.apache.sling.fileoptim.FileOptimizerService;
import org.apache.sling.fileoptim.OptimizationResult;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={Servlet.class}, property={"sling.servlet.paths=/system/fileoptim/preview", "sling.servlet.methods=GET"}, immediate=true)
public class FileOptimizerPreview
extends SlingSafeMethodsServlet {
    @Reference
    private transient FileOptimizerService fileOptimizer;
    private static final long serialVersionUID = 8635343288414416865L;

    protected void doGet(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        String path = request.getParameter("path");
        Resource resource = request.getResourceResolver().getResource(path);
        if (resource == null) {
            response.sendError(404, "No Resource found at path " + path);
        } else if (this.fileOptimizer.canOptimize(resource)) {
            OptimizationResult res = this.fileOptimizer.getOptimizedContents(resource);
            ValueMap vm = res.getResource().getValueMap();
            response.setContentType((String)vm.get("jcr:mimeType", String.class));
            response.setHeader("Content-disposition", "inline; filename=" + resource.getName());
            IOUtils.copy((InputStream)res.getOptimizedContentStream(), (OutputStream)response.getOutputStream());
        } else {
            response.sendError(400, "Resource at path " + path + " is not a file or cannot be optimized");
        }
    }
}

