/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.fileoptim.impl;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.sling.api.resource.ModifiableValueMap;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.fileoptim.FileOptimizer;
import org.apache.sling.fileoptim.FileOptimizerService;
import org.apache.sling.fileoptim.OptimizationResult;
import org.apache.sling.fileoptim.models.OptimizedFile;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={FileOptimizerService.class}, immediate=true)
@Designate(ocd=Config.class)
public class FileOptimizerServiceImpl
implements FileOptimizerService,
ServiceListener {
    private static final Logger log = LoggerFactory.getLogger(FileOptimizerServiceImpl.class);
    private BundleContext bundleContext;
    private Config config;
    private Map<String, List<ServiceReference<FileOptimizer>>> fileOptimizers = new HashMap<String, List<ServiceReference<FileOptimizer>>>();

    @Activate
    @Modified
    public void activate(ComponentContext context, Config config) throws InvalidSyntaxException {
        this.bundleContext = context.getBundleContext();
        this.config = config;
        this.rebuildOptimizerCache();
        this.bundleContext.addServiceListener((ServiceListener)this, "(objectClass=" + FileOptimizer.class.getName() + ")");
    }

    private void addOptimizer(Map<String, List<ServiceReference<FileOptimizer>>> tempCache, String metaType, ServiceReference<FileOptimizer> ref) {
        if (!tempCache.containsKey(metaType)) {
            tempCache.put(metaType, new ArrayList());
        }
        tempCache.get(metaType).add(ref);
    }

    private String calculateHash(byte[] bytes) {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance(this.config.hashAlgorithm());
            messageDigest.reset();
            messageDigest.update(bytes);
            return Base64.encodeBase64String((byte[])messageDigest.digest());
        }
        catch (NoSuchAlgorithmException e) {
            log.error("Exception generating hash", (Throwable)e);
            return null;
        }
    }

    @Override
    public boolean canOptimize(Resource fileResource) {
        OptimizedFile of;
        if (!fileResource.getName().equals("jcr:content") && fileResource.getChild("jcr:content") != null) {
            fileResource = fileResource.getChild("jcr:content");
        }
        return (of = (OptimizedFile)fileResource.adaptTo(OptimizedFile.class)) != null && !of.getDisabled() && this.fileOptimizers.containsKey(of.getMimeType()) && !this.fileOptimizers.get(of.getMimeType()).isEmpty();
    }

    @Deactivate
    public void deactivate(ComponentContext context) {
        context.getBundleContext().removeServiceListener((ServiceListener)this);
    }

    public Map<String, List<ServiceReference<FileOptimizer>>> getFileOptimizers() {
        return this.fileOptimizers;
    }

    @Override
    public OptimizationResult getOptimizedContents(Resource fileResource) throws IOException {
        if (!fileResource.getName().equals("jcr:content") && fileResource.getChild("jcr:content") != null) {
            fileResource = fileResource.getChild("jcr:content");
        }
        OptimizationResult result = new OptimizationResult(fileResource);
        OptimizedFile optim = (OptimizedFile)fileResource.adaptTo(OptimizedFile.class);
        boolean optimize = true;
        byte[] original = IOUtils.toByteArray((InputStream)optim.getContent());
        if (StringUtils.isNotBlank((String)optim.getHash()) && optim.getHash().equals(this.calculateHash(original))) {
            optimize = false;
        }
        if (optimize) {
            this.doOptimize(fileResource, result, optim, original);
        } else {
            log.trace("Resource {} is already optimized", (Object)fileResource);
        }
        return result;
    }

    private void doOptimize(Resource fileResource, OptimizationResult result, OptimizedFile optim, byte[] original) {
        log.debug("Optimizing file resource {}", (Object)fileResource);
        List<ServiceReference<FileOptimizer>> optimizers = this.fileOptimizers.get(optim.getMimeType());
        for (ServiceReference<FileOptimizer> ref : optimizers) {
            FileOptimizer optimizer = (FileOptimizer)this.bundleContext.getService(ref);
            if (optimizer == null) {
                log.warn("No service retrieved for service reference {}", ref);
                continue;
            }
            byte[] optimized = optimizer.optimizeFile(original, optim.getMimeType());
            if (optimized != null && optimized.length < original.length) {
                double savings = 1.0 - (double)optimized.length / (double)original.length;
                log.debug("Optimized file with {} saving {}%", (Object)optimizer.getName(), (Object)Math.round(savings * 100.0));
                result.setAlgorithm(optimizer.getName());
                result.setSavings(savings);
                result.setOptimized(true);
                result.setOptimizedSize(optimized.length);
                result.setOriginalSize(original.length);
                result.setOptimizedContents(optimized);
                continue;
            }
            log.debug("Optimizer {} was not able to optimize the file", (Object)optimizer.getName());
        }
    }

    @Override
    public boolean isOptimized(Resource fileResource) {
        if (!fileResource.getName().equals("jcr:content") && fileResource.getChild("jcr:content") != null) {
            fileResource = fileResource.getChild("jcr:content");
        }
        OptimizedFile of = (OptimizedFile)fileResource.adaptTo(OptimizedFile.class);
        try {
            String calculatedHash = this.calculateHash(IOUtils.toByteArray((InputStream)of.getContent()));
            log.debug("Comparing stored {} and calculated {} hashes", (Object)of.getHash(), (Object)calculatedHash);
            return ObjectUtils.equals((Object)of.getHash(), (Object)calculatedHash);
        }
        catch (IOException e) {
            log.error("Exception checking if file optimized, assuming false", (Throwable)e);
            return false;
        }
    }

    @Override
    public OptimizationResult optimizeFile(Resource fileResource, boolean autoCommit) throws IOException {
        OptimizationResult result = this.getOptimizedContents(fileResource);
        ModifiableValueMap mvm = (ModifiableValueMap)fileResource.adaptTo(ModifiableValueMap.class);
        HashSet<Object> mixins = new HashSet<Object>(Arrays.asList((Object[])mvm.get("jcr:mixinTypes", (Object)new String[0])));
        mixins.add("optim:optimized");
        mvm.put((Object)"jcr:mixinTypes", (Object)mixins.toArray(new String[0]));
        mvm.put((Object)"optim:algrithm", (Object)result.getAlgorithm());
        mvm.put((Object)"optim:hash", (Object)this.calculateHash(result.getOptimizedContents()));
        mvm.put((Object)"optim:original", mvm.get("jcr:data", InputStream.class));
        mvm.put((Object)"optim:savings", (Object)result.getSavings());
        mvm.put((Object)"jcr:data", (Object)new ByteArrayInputStream(result.getOptimizedContents()));
        if (autoCommit) {
            log.debug("Persisting changes...");
            fileResource.getResourceResolver().commit();
        }
        return result;
    }

    private void rebuildOptimizerCache() {
        log.debug("rebuildOptimizerCache");
        HashMap<String, List<ServiceReference<FileOptimizer>>> tempCache = new HashMap<String, List<ServiceReference<FileOptimizer>>>();
        Collection references = null;
        try {
            references = this.bundleContext.getServiceReferences(FileOptimizer.class, null);
        }
        catch (Exception e) {
            log.error("Exception retrieving service references", (Throwable)e);
        }
        for (ServiceReference ref : references) {
            Object mimeType = ref.getProperty("mime.type");
            if (mimeType instanceof String[]) {
                for (String mt : (String[])mimeType) {
                    this.addOptimizer(tempCache, mt, (ServiceReference<FileOptimizer>)ref);
                }
                continue;
            }
            if (mimeType == null) continue;
            this.addOptimizer(tempCache, (String)mimeType, (ServiceReference<FileOptimizer>)ref);
        }
        for (List optList : tempCache.values()) {
            Collections.sort(optList);
        }
        this.fileOptimizers = tempCache;
    }

    public void serviceChanged(ServiceEvent event) {
        this.rebuildOptimizerCache();
    }

    public void setFileOptimizers(Map<String, List<ServiceReference<FileOptimizer>>> fileOptimizers) {
        this.fileOptimizers = fileOptimizers;
    }

    @ObjectClassDefinition(name="%file.optimizer.name", description="%file.optimizer.description", localization="OSGI-INF/l10n/bundle")
    public static @interface Config {
        @AttributeDefinition(name="%file.optimizer.hash.algorithm.name", description="%file.optimizer.hash.algorithm.description")
        public String hashAlgorithm() default "MD5";
    }
}

