/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.fileoptim.optimizers;

import com.googlecode.pngtastic.core.PngImage;
import com.googlecode.pngtastic.core.PngOptimizer;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.apache.sling.fileoptim.FileOptimizer;
import org.osgi.service.component.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={FileOptimizer.class}, property={"mime.type=image/png"})
public class PngFileOptimizer
implements FileOptimizer {
    private static final Logger log = LoggerFactory.getLogger(PngFileOptimizer.class);

    @Override
    public byte[] optimizeFile(byte[] original, String metaType) {
        PngOptimizer optimizer = new PngOptimizer();
        PngImage image = new PngImage(new ByteArrayInputStream(original));
        try {
            PngImage optimized = optimizer.optimize(image);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            optimized.writeDataOutputStream(baos);
            return baos.toByteArray();
        }
        catch (IOException e) {
            log.warn("Exception optimizing PNG image", (Throwable)e);
            return null;
        }
    }

    @Override
    public String getName() {
        return "PNGTastic PNG Optimizer";
    }
}

