/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.fileoptim.optimizers;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.stream.MemoryCacheImageOutputStream;
import org.apache.sling.fileoptim.FileOptimizer;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={FileOptimizer.class}, property={"mime.type=image/jpeg"})
@Designate(ocd=Config.class)
public class JpegFileOptimizer
implements FileOptimizer {
    private static final Logger log = LoggerFactory.getLogger(JpegFileOptimizer.class);
    private Config config;

    @Activate
    @Modified
    public void activate(Config config) {
        this.config = config;
    }

    @Override
    public byte[] optimizeFile(byte[] original, String metaType) {
        ImageWriter jpgWriter = ImageIO.getImageWritersByFormatName("jpg").next();
        ImageWriteParam jpgWriteParam = jpgWriter.getDefaultWriteParam();
        jpgWriteParam.setCompressionMode(2);
        jpgWriteParam.setCompressionQuality(this.config.compressionLevel());
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        MemoryCacheImageOutputStream outputStream = new MemoryCacheImageOutputStream(baos);
        jpgWriter.setOutput(outputStream);
        try {
            IIOImage outputImage = new IIOImage(ImageIO.read(new ByteArrayInputStream(original)), null, null);
            jpgWriter.write(null, outputImage, jpgWriteParam);
            jpgWriter.dispose();
            return baos.toByteArray();
        }
        catch (IOException e) {
            log.warn("Exception optimizing image", (Throwable)e);
            return null;
        }
    }

    @Override
    public String getName() {
        return "Apache Sling JPEG File Optimizer";
    }

    @ObjectClassDefinition(name="%jpeg.optimizer.name", description="%jpeg.optimizer.description", localization="OSGI-INF/l10n/bundle")
    public static @interface Config {
        @AttributeDefinition(name="%jpeg.optimizer.compression.level.name", description="%jpeg.optimizer.compression.level.description")
        public float compressionLevel() default 0.8f;
    }
}

