/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.fileoptim.models;

import java.io.IOException;
import javax.annotation.PostConstruct;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.fileoptim.FileOptimizerService;
import org.apache.sling.fileoptim.OptimizationResult;
import org.apache.sling.models.annotations.Model;
import org.apache.sling.models.annotations.injectorspecific.OSGiService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Model(adaptables={Resource.class})
public class OptimizeResource {
    private static final Logger log = LoggerFactory.getLogger(OptimizeResource.class);
    private boolean canOptimize;
    @OSGiService
    private FileOptimizerService fileOptimizer;
    private OptimizationResult result;
    private Resource resource;

    public OptimizeResource(Resource resource) {
        this.resource = resource;
    }

    @PostConstruct
    public void init() throws PersistenceException, IOException {
        log.debug("initializing with resource {}", (Object)this.resource);
        if (this.fileOptimizer.canOptimize(this.resource)) {
            this.canOptimize = true;
            this.result = this.fileOptimizer.getOptimizedContents(this.resource);
        } else {
            this.canOptimize = false;
            this.result = null;
        }
    }

    public boolean isOptimized() {
        return this.fileOptimizer.isOptimized(this.resource);
    }

    public OptimizationResult getResult() {
        return this.result;
    }

    public boolean isCanOptimize() {
        return this.canOptimize;
    }
}

