/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.fileoptim;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.apache.sling.api.resource.Resource;

public class OptimizationResult {
    private String algorithm;
    private boolean optimized = false;
    private byte[] optimizedContents;
    private long optimizedSize;
    private long originalSize;
    private final Resource resource;
    private double savings = 0.0;

    public OptimizationResult(Resource resource) {
        this.resource = resource;
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public byte[] getOptimizedContents() {
        return this.optimizedContents;
    }

    public InputStream getOptimizedContentStream() {
        return new ByteArrayInputStream(this.optimizedContents);
    }

    public long getOptimizedSize() {
        return this.optimizedSize;
    }

    public long getOriginalSize() {
        return this.originalSize;
    }

    public Resource getResource() {
        return this.resource;
    }

    public double getSavings() {
        return this.savings;
    }

    public boolean isOptimized() {
        return this.optimized;
    }

    public void setAlgorithm(String algorithm) {
        this.algorithm = algorithm;
    }

    public void setOptimized(boolean optimized) {
        this.optimized = optimized;
    }

    public void setOptimizedContents(byte[] optimizedContents) {
        this.optimizedContents = optimizedContents;
    }

    public void setOptimizedSize(long optimizedSize) {
        this.optimizedSize = optimizedSize;
    }

    public void setOriginalSize(long originalSize) {
        this.originalSize = originalSize;
    }

    public void setSavings(double savings) {
        this.savings = savings;
    }
}

