/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.sling.feature.Artifact;
import org.apache.sling.feature.Artifacts;

public class Bundles
extends Artifacts {
    private static final long serialVersionUID = 5134067638024826299L;

    public Map<Integer, List<Artifact>> getBundlesByStartOrder() {
        TreeMap<Integer, ArrayList<Artifact>> startOrderMap = new TreeMap<Integer, ArrayList<Artifact>>(new Comparator<Integer>(){

            @Override
            public int compare(Integer o1, Integer o2) {
                if (o1 == o2) {
                    return 0;
                }
                if (o1 == 0) {
                    return 1;
                }
                if (o2 == 0) {
                    return -1;
                }
                return o1 - o2;
            }
        });
        for (Artifact bundle : this) {
            int startOrder = bundle.getStartOrder();
            ArrayList<Artifact> list = (ArrayList<Artifact>)startOrderMap.get(startOrder);
            if (list == null) {
                list = new ArrayList<Artifact>();
                startOrderMap.put(startOrder, list);
            }
            list.add(bundle);
        }
        return Collections.unmodifiableMap(startOrderMap);
    }
}

