/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.io.impl.felix.utils.resource;

import java.util.Map;
import java.util.Objects;
import org.apache.sling.feature.io.impl.felix.utils.collections.StringArrayMap;
import org.apache.sling.feature.io.impl.felix.utils.resource.ResourceUtils;
import org.osgi.resource.Resource;

abstract class AbstractCapabilityRequirement {
    protected final Resource resource;
    protected final String namespace;
    protected final Map<String, String> directives;
    protected final Map<String, Object> attributes;

    AbstractCapabilityRequirement(Resource res, String ns, Map<String, String> dirs, Map<String, Object> attrs) {
        this.resource = res;
        this.namespace = Objects.requireNonNull(ns, "Namespace must not be null.");
        this.directives = StringArrayMap.reduceMemory(dirs);
        this.attributes = StringArrayMap.reduceMemory(attrs);
    }

    public String getNamespace() {
        return this.namespace;
    }

    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    public Map<String, String> getDirectives() {
        return this.directives;
    }

    public Resource getResource() {
        return this.resource;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractCapabilityRequirement that = (AbstractCapabilityRequirement)o;
        return Objects.equals(this.resource, that.resource) && Objects.equals(this.namespace, that.namespace) && Objects.equals(this.attributes, that.attributes) && Objects.equals(this.directives, that.directives);
    }

    public int hashCode() {
        return Objects.hash(this.resource, this.namespace, this.attributes, this.directives);
    }

    public String toString() {
        return ResourceUtils.toString(this.getResource(), this.getNamespace(), this.getAttributes(), this.getDirectives());
    }
}

