/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.io.artifacts;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import java.util.ServiceLoader;
import org.apache.sling.feature.ArtifactId;
import org.apache.sling.feature.io.artifacts.ArtifactHandler;
import org.apache.sling.feature.io.artifacts.ArtifactManagerConfig;
import org.apache.sling.feature.io.artifacts.spi.ArtifactProvider;
import org.apache.sling.feature.io.artifacts.spi.ArtifactProviderContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArtifactManager
implements AutoCloseable {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Map<String, ArtifactProvider> providers;
    private final ArtifactManagerConfig config;

    public static ArtifactManager getArtifactManager(ArtifactManagerConfig config) throws IOException {
        ServiceLoader<ArtifactProvider> loader = ServiceLoader.load(ArtifactProvider.class);
        HashMap<String, ArtifactProvider> providers = new HashMap<String, ArtifactProvider>();
        for (ArtifactProvider provider : loader) {
            providers.put(provider.getProtocol(), provider);
        }
        String[] repositoryURLs = new String[config.getRepositoryUrls().length];
        int index = 0;
        String[] stringArray = config.getRepositoryUrls();
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String urlString;
            repositoryURLs[index] = urlString = stringArray[i];
            ++index;
        }
        if (!providers.containsKey("*")) {
            providers.put("*", new DefaultArtifactHandler());
        }
        return new ArtifactManager(config, providers);
    }

    ArtifactManager(ArtifactManagerConfig config, Map<String, ArtifactProvider> providers) throws IOException {
        this.config = config;
        this.providers = providers;
        try {
            for (ArtifactProvider provider : this.providers.values()) {
                provider.init(config);
            }
        }
        catch (IOException io) {
            this.shutdown();
            throw io;
        }
    }

    public void shutdown() {
        for (ArtifactProvider provider : this.providers.values()) {
            provider.shutdown();
        }
        this.providers.clear();
    }

    @Override
    public void close() {
        this.shutdown();
    }

    private final URL getArtifactFromProviders(String url, String relativeCachePath) throws IOException {
        int pos = url.indexOf(":");
        String scheme = url.substring(0, pos);
        ArtifactProvider provider = this.providers.get(scheme);
        if (provider == null) {
            provider = this.providers.get("*");
        }
        if (provider == null) {
            throw new IOException("No URL provider found for " + url);
        }
        return provider.getArtifact(url, relativeCachePath);
    }

    public ArtifactHandler getArtifactHandler(String url) throws IOException {
        String path;
        this.logger.debug("Trying to get artifact for {}", (Object)url);
        if (url.startsWith("mvn:")) {
            path = ArtifactId.fromMvnUrl((String)url).toMvnPath();
        } else if (url.startsWith(":")) {
            path = url.substring(1);
        } else {
            if (url.indexOf(":/") > 0) {
                int pos = url.indexOf(":/") + 2;
                while (url.charAt(pos) == '/') {
                    ++pos;
                }
                URL file = this.getArtifactFromProviders(url, url.substring(pos));
                if (file == null) {
                    throw new IOException("Artifact " + url + " not found.");
                }
                return new ArtifactHandler(url, file);
            }
            File f = new File(url);
            if (!f.exists()) {
                throw new IOException("Artifact " + url + " not found.");
            }
            return new ArtifactHandler(f.toURI().toString(), f.toURI().toURL());
        }
        this.logger.debug("Querying repositories for {}", (Object)path);
        for (String repoUrl : this.config.getRepositoryUrls()) {
            StringBuilder builder = new StringBuilder();
            builder.append(repoUrl);
            builder.append('/');
            builder.append(path);
            String artifactUrl = builder.toString();
            int pos = artifactUrl.indexOf(":");
            String scheme = artifactUrl.substring(0, pos);
            ArtifactProvider handler = this.providers.get(scheme);
            if (handler == null) {
                handler = this.providers.get("*");
            }
            if (handler == null) {
                throw new IOException("No URL handler found for " + artifactUrl);
            }
            this.logger.debug("Checking {} to get artifact from {}", (Object)handler, (Object)artifactUrl);
            URL file = handler.getArtifact(artifactUrl, path);
            if (file != null) {
                this.logger.debug("Found artifact {}", (Object)artifactUrl);
                return new ArtifactHandler(artifactUrl, file);
            }
            int lastSlash = artifactUrl.lastIndexOf(47);
            int startSnapshot = artifactUrl.indexOf("-SNAPSHOT", lastSlash + 1);
            if (startSnapshot <= -1) continue;
            String metadataUrl = artifactUrl.substring(0, lastSlash) + "/maven-metadata.xml";
            try {
                ArtifactHandler metadataHandler = this.getArtifactHandler(metadataUrl);
                String contents = this.getFileContents(metadataHandler);
                String latestVersion = ArtifactManager.getLatestSnapshot(contents);
                if (latestVersion == null) continue;
                String name = artifactUrl.substring(lastSlash);
                String fullURL = artifactUrl.substring(0, lastSlash) + name.replace("SNAPSHOT", latestVersion);
                int pos2 = fullURL.indexOf(":/") + 2;
                while (fullURL.charAt(pos2) == '/') {
                    ++pos2;
                }
                URL file2 = this.getArtifactFromProviders(fullURL, path);
                if (file2 == null) {
                    throw new IOException("Artifact " + fullURL + " not found.");
                }
                return new ArtifactHandler(artifactUrl, file2);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        throw new IOException("Artifact " + url + " not found in any repository.");
    }

    protected String getFileContents(ArtifactHandler handler) throws IOException {
        StringBuilder sb = new StringBuilder();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(handler.getLocalURL().openStream(), "UTF-8"));){
            String line = reader.readLine();
            while (line != null) {
                sb.append(line).append('\n');
                line = reader.readLine();
            }
        }
        return sb.toString();
    }

    public static String getValue(String xml, String[] xpath) {
        int endPos;
        String value = null;
        int pos = 0;
        for (String name : xpath) {
            String elementWithAttributes;
            String element = '<' + name + '>';
            pos = xml.indexOf(element, pos);
            if (pos == -1 && (pos = xml.indexOf(elementWithAttributes = '<' + name + ' ', pos)) == -1) break;
            pos = xml.indexOf(62, pos) + 1;
        }
        if (pos != -1 && (endPos = xml.indexOf("</", pos)) != -1) {
            value = xml.substring(pos, endPos).trim();
        }
        return value;
    }

    public static String getLatestSnapshot(String mavenMetadata) {
        String timestamp = ArtifactManager.getValue(mavenMetadata, new String[]{"metadata", "versioning", "snapshot", "timestamp"});
        String buildNumber = ArtifactManager.getValue(mavenMetadata, new String[]{"metadata", "versioning", "snapshot", "buildNumber"});
        if (timestamp != null && buildNumber != null) {
            return timestamp + '-' + buildNumber;
        }
        return null;
    }

    private static final class DefaultArtifactHandler
    implements ArtifactProvider {
        private final Logger logger = LoggerFactory.getLogger(this.getClass());
        private volatile File cacheDir;
        private volatile ArtifactProviderContext config;

        private DefaultArtifactHandler() {
        }

        @Override
        public String getProtocol() {
            return "*";
        }

        @Override
        public void init(ArtifactProviderContext config) throws IOException {
            this.cacheDir = config.getCacheDirectory();
            this.config = config;
        }

        @Override
        public void shutdown() {
            this.config = null;
            this.cacheDir = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public URL getArtifact(String url, String relativeCachePath) {
            this.logger.debug("Checking url to be local file {}", (Object)url);
            try {
                File f = new File(new URL(url).toURI());
                if (f.exists()) {
                    this.config.incLocalArtifacts();
                    return f.toURI().toURL();
                }
                return null;
            }
            catch (URISyntaxException f) {
            }
            catch (IllegalArgumentException f) {
            }
            catch (MalformedURLException f) {
                // empty catch block
            }
            this.logger.debug("Checking remote url {}", (Object)url);
            try {
                if (url.indexOf(":") == -1) {
                    return null;
                }
                String filePath = (this.cacheDir.getAbsolutePath() + File.separatorChar + relativeCachePath).replace('/', File.separatorChar);
                File cacheFile = new File(filePath);
                if (!cacheFile.exists()) {
                    cacheFile.getParentFile().mkdirs();
                    URL u = new URL(url);
                    URLConnection con = u.openConnection();
                    String userInfo = u.getUserInfo();
                    if (userInfo != null) {
                        con.addRequestProperty("Authorization", "Basic " + Base64.getEncoder().encodeToString(u.toURI().getUserInfo().getBytes("UTF-8")));
                    }
                    con.connect();
                    InputStream readIS = con.getInputStream();
                    byte[] buffer = new byte[32768];
                    FileOutputStream os = null;
                    try {
                        int l;
                        os = new FileOutputStream(cacheFile);
                        while ((l = readIS.read(buffer)) >= 0) {
                            ((OutputStream)os).write(buffer, 0, l);
                        }
                    }
                    finally {
                        try {
                            readIS.close();
                        }
                        catch (IOException iOException) {}
                        if (os != null) {
                            try {
                                ((OutputStream)os).close();
                            }
                            catch (IOException iOException) {}
                        }
                    }
                    this.config.incDownloadedArtifacts();
                } else {
                    this.config.incCachedArtifacts();
                }
                return cacheFile.toURI().toURL();
            }
            catch (Exception e) {
                this.logger.info("Artifact not found in one repository", (Throwable)e);
                return null;
            }
        }

        public String toString() {
            return "DefaultArtifactHandler";
        }
    }
}

