/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.provisioning.model;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.StringReader;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Properties;
import org.apache.felix.cm.file.ConfigurationHandler;
import org.apache.sling.provisioning.model.Artifact;
import org.apache.sling.provisioning.model.Configuration;
import org.apache.sling.provisioning.model.Feature;
import org.apache.sling.provisioning.model.ModelUtility;

public class ModelResolveUtility {
    private ModelResolveUtility() {
    }

    public static String replace(Feature feature, String v, ModelUtility.VariableResolver resolver) {
        if (v == null) {
            return null;
        }
        String msg = v;
        int pos = -1;
        int start = 0;
        while ((pos = msg.indexOf(36, start)) != -1) {
            int endPos;
            boolean escapedVariable;
            boolean bl = escapedVariable = pos > 0 && msg.charAt(pos - 1) == '\\';
            if (msg.length() > pos && msg.charAt(pos + 1) == '{' && (pos == 0 || msg.charAt(pos - 1) != '$') && (endPos = msg.indexOf(125, pos)) != -1) {
                String name = msg.substring(pos + 2, endPos);
                String value = escapedVariable ? "\\${" + name + "}" : (resolver != null ? resolver.resolve(feature, name) : feature.getVariables().get(name));
                if (value == null) {
                    throw new IllegalArgumentException("Unknown variable: " + name);
                }
                int startPos = escapedVariable ? pos - 1 : pos;
                msg = msg.substring(0, startPos) + value + msg.substring(endPos + 1);
            }
            start = pos + 1;
        }
        return msg;
    }

    static String resolveArtifactVersion(String groupId, String artifactId, String version, String classifier, String type, ModelUtility.ArtifactVersionResolver artifactVersionResolver) {
        String newVersion;
        if (artifactVersionResolver != null && (version == null || "LATEST".equals(version)) && (newVersion = artifactVersionResolver.resolve(new Artifact(groupId, artifactId, version, classifier, type))) != null) {
            return newVersion;
        }
        return version;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static void getProcessedConfiguration(Feature feature, Configuration newConfig, Configuration config, boolean replaceVariables, ModelUtility.VariableResolver resolver) {
        newConfig.setComment(config.getComment());
        newConfig.setLocation(config.getLocation());
        String rawConfig = (String)config.getProperties().get(":rawconfig");
        if (rawConfig != null) {
            if (replaceVariables) {
                rawConfig = ModelResolveUtility.replace(feature, rawConfig, resolver);
            }
            if (config.isSpecial()) {
                newConfig.getProperties().put(config.getPid(), rawConfig);
                return;
            }
            String format = (String)config.getProperties().get(":rawconfig.format");
            if ("properties".equals(format)) {
                Properties props = new Properties();
                try {
                    props.load(new StringReader(rawConfig));
                }
                catch (IOException ioe) {
                    throw new IllegalArgumentException("Unable to read configuration properties.", ioe);
                }
                Enumeration<Object> i = props.keys();
                while (i.hasMoreElements()) {
                    String key = (String)i.nextElement();
                    newConfig.getProperties().put(key, props.get(key));
                }
                return;
            }
            StringBuilder sb = new StringBuilder();
            try {
                LineNumberReader lnr = new LineNumberReader(new StringReader(rawConfig));
                String line = null;
                while ((line = lnr.readLine()) != null) {
                    if ((line = line.trim()).isEmpty() || line.startsWith("#")) continue;
                    sb.append(line);
                    sb.append('\n');
                }
            }
            catch (IOException ioe) {
                throw new IllegalArgumentException("Unable to read configuration properties: " + config, ioe);
            }
            ByteArrayInputStream bais = null;
            try {
                bais = new ByteArrayInputStream(sb.toString().getBytes("UTF-8"));
                Dictionary props = ConfigurationHandler.read(bais);
                Enumeration i = props.keys();
                while (i.hasMoreElements()) {
                    String key = (String)i.nextElement();
                    newConfig.getProperties().put(key, props.get(key));
                }
                return;
            }
            catch (IOException ioe) {
                throw new IllegalArgumentException("Unable to read configuration properties: " + config, ioe);
            }
            finally {
                if (bais != null) {
                    try {
                        bais.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        Enumeration<String> i = config.getProperties().keys();
        while (i.hasMoreElements()) {
            String key = i.nextElement();
            newConfig.getProperties().put(key, config.getProperties().get(key));
        }
    }
}

