/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.modelconverter;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.sling.feature.io.ArtifactManager;
import org.apache.sling.feature.io.ArtifactManagerConfig;
import org.apache.sling.feature.modelconverter.ProvisioningToFeature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Main {
    private static Logger LOGGER;
    private static String runModes;
    private static String output;
    private static String input;
    private static boolean createApp;
    private static boolean includeModelInfo;
    private static String repoUrls;
    private static String propsFile;

    private static void parseArgs(String[] args) {
        Option repoOption = Option.builder("u").hasArg().argName("Set repository url").desc("repository url").required().build();
        Option modelOption = new Option("f", true, "Set feature files/directories");
        Option propsOption = new Option("p", true, "sling.properties file");
        Option runModeOption = new Option("r", true, "Set run modes (comma separated)");
        Option createAppOption = new Option("a", false, "If enabled, create application json");
        createAppOption.setArgs(0);
        Option includeModelOption = new Option("i", false, "Include model filename as metadata for artifacts");
        includeModelOption.setArgs(0);
        Option outputOption = Option.builder("o").hasArg().argName("Set output file").desc("output file").build();
        Options options = new Options();
        options.addOption(repoOption);
        options.addOption(modelOption);
        options.addOption(createAppOption);
        options.addOption(outputOption);
        options.addOption(includeModelOption);
        options.addOption(propsOption);
        options.addOption(runModeOption);
        DefaultParser parser = new DefaultParser();
        try {
            CommandLine cl = parser.parse(options, args);
            if (cl.hasOption(repoOption.getOpt())) {
                repoUrls = cl.getOptionValue(repoOption.getOpt());
            }
            if (cl.hasOption(modelOption.getOpt())) {
                input = cl.getOptionValue(modelOption.getOpt());
            }
            if (cl.hasOption(createAppOption.getOpt())) {
                createApp = true;
            }
            if (cl.hasOption(includeModelOption.getOpt())) {
                includeModelInfo = true;
            }
            if (cl.hasOption(runModeOption.getOpt())) {
                runModes = cl.getOptionValue(runModeOption.getOpt());
            }
            if (cl.hasOption(outputOption.getOpt())) {
                output = cl.getOptionValue(outputOption.getOpt());
            }
            if (cl.hasOption(propsOption.getOpt())) {
                propsFile = cl.getOptionValue(propsOption.getOpt());
            }
        }
        catch (ParseException pe) {
            LOGGER.error("Unable to parse command line: {}", (Object)pe.getMessage(), (Object)pe);
            System.exit(1);
        }
        if (input == null) {
            LOGGER.error("Required argument missing: model file or directory");
            System.exit(1);
        }
    }

    private static ArtifactManager getArtifactManager() {
        ArtifactManagerConfig amConfig = new ArtifactManagerConfig();
        if (repoUrls != null) {
            amConfig.setRepositoryUrls(repoUrls.split(","));
        }
        try {
            return ArtifactManager.getArtifactManager((ArtifactManagerConfig)amConfig);
        }
        catch (IOException ioe) {
            LOGGER.error("Unable to create artifact manager " + ioe.getMessage(), ioe);
            System.exit(1);
            return null;
        }
    }

    public static void main(String[] args) {
        System.setProperty("org.slf4j.simpleLogger.defaultLogLevel", "info");
        System.setProperty("org.slf4j.simpleLogger.showThreadName", "false");
        System.setProperty("org.slf4j.simpleLogger.levelInBrackets", "true");
        System.setProperty("org.slf4j.simpleLogger.showLogName", "false");
        LOGGER = LoggerFactory.getLogger("modelconverter");
        LOGGER.info("Apache Sling Provisiong Model to Feature Application Converter");
        LOGGER.info("");
        Main.parseArgs(args);
        ArtifactManagerConfig amConfig = new ArtifactManagerConfig();
        if (repoUrls != null) {
            amConfig.setRepositoryUrls(repoUrls.split(","));
        }
        ArtifactManager am = Main.getArtifactManager();
        File f = new File(input);
        ArrayList<File> files = new ArrayList<File>();
        if (f.isDirectory()) {
            for (File file : f.listFiles()) {
                if (!file.isFile() || file.getName().startsWith(".")) continue;
                files.add(file);
            }
            if (files.isEmpty()) {
                LOGGER.error("No files found in {}", (Object)f);
                System.exit(1);
            }
            Collections.sort(files);
        } else {
            files.add(f);
        }
        boolean isJson = false;
        boolean isTxt = false;
        for (File t : files) {
            if (t.getName().endsWith(".json")) {
                if (isTxt) {
                    LOGGER.error("Input files are a mixture of JSON and txt");
                    System.exit(1);
                }
                isJson = true;
                continue;
            }
            if (isJson) {
                LOGGER.error("Input files are a mixture of JSON and txt");
                System.exit(1);
            }
            isTxt = true;
        }
        if (isTxt) {
            if (output == null) {
                output = createApp ? "application.json" : "feature.json";
            }
            ProvisioningToFeature.convert(files, output, runModes, createApp, includeModelInfo, propsFile);
        } else {
            if (output == null) {
                output = createApp ? "application.txt" : "feature.txt";
            }
            try {
                throw new IOException("Not yet supported");
            }
            catch (IOException ioe) {
                LOGGER.error("Unable to read feature/application files " + ioe.getMessage(), ioe);
                System.exit(1);
            }
            catch (Exception e) {
                LOGGER.error("Problem generating application", e);
                System.exit(1);
            }
        }
    }

    static {
        createApp = false;
        includeModelInfo = false;
    }
}

