/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.launcher.impl;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Spliterators;
import java.util.stream.StreamSupport;
import org.apache.sling.feature.Artifact;
import org.apache.sling.feature.ArtifactId;
import org.apache.sling.feature.Configuration;
import org.apache.sling.feature.Extension;
import org.apache.sling.feature.ExtensionState;
import org.apache.sling.feature.Feature;
import org.apache.sling.feature.builder.ArtifactProvider;
import org.apache.sling.feature.builder.BuilderContext;
import org.apache.sling.feature.builder.FeatureBuilder;
import org.apache.sling.feature.builder.MergeHandler;
import org.apache.sling.feature.builder.PostProcessHandler;
import org.apache.sling.feature.io.IOUtils;
import org.apache.sling.feature.io.archive.ArchiveReader;
import org.apache.sling.feature.io.artifacts.ArtifactHandler;
import org.apache.sling.feature.io.artifacts.ArtifactManager;
import org.apache.sling.feature.io.json.FeatureJSONReader;
import org.apache.sling.feature.launcher.impl.ExtensionContextImpl;
import org.apache.sling.feature.launcher.impl.LauncherConfig;
import org.apache.sling.feature.launcher.spi.LauncherPrepareContext;
import org.apache.sling.feature.launcher.spi.extensions.ExtensionHandler;
import org.slf4j.Logger;

public class FeatureProcessor {
    public static Feature createApplication(Logger logger, LauncherConfig config, final ArtifactManager artifactManager, Map<ArtifactId, Feature> loadedFeatures) throws IOException {
        BuilderContext builderContext = new BuilderContext(id -> {
            Feature feature;
            ArtifactHandler handler = artifactManager.getArtifactHandler(id.toMvnUrl());
            InputStreamReader r = new InputStreamReader(handler.getLocalURL().openStream(), "UTF-8");
            try {
                Feature f;
                feature = f = FeatureJSONReader.read(r, handler.getUrl());
            }
            catch (Throwable throwable) {
                try {
                    try {
                        ((Reader)r).close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    return null;
                }
            }
            ((Reader)r).close();
            return feature;
        });
        ArtifactProvider provider = new ArtifactProvider(){

            @Override
            public URL provide(ArtifactId id) {
                try {
                    ArtifactHandler handler = artifactManager.getArtifactHandler(id.toMvnUrl());
                    return handler.getLocalURL();
                }
                catch (IOException e) {
                    return null;
                }
            }
        };
        builderContext.setArtifactProvider(provider);
        config.getArtifactClashOverrides().stream().forEach(id -> builderContext.addArtifactsOverride((ArtifactId)id));
        builderContext.addConfigsOverrides(config.getConfigClashOverrides());
        builderContext.addVariablesOverrides(config.getVariables());
        builderContext.addFrameworkPropertiesOverrides(config.getInstallation().getFrameworkProperties());
        builderContext.addMergeExtensions((MergeHandler[])StreamSupport.stream(Spliterators.spliteratorUnknownSize(ServiceLoader.load(MergeHandler.class).iterator(), 16), false).toArray(MergeHandler[]::new));
        builderContext.addPostProcessExtensions((PostProcessHandler[])StreamSupport.stream(Spliterators.spliteratorUnknownSize(ServiceLoader.load(PostProcessHandler.class).iterator(), 16), false).toArray(PostProcessHandler[]::new));
        for (Map.Entry<String, Map<String, String>> entry : config.getExtensionConfiguration().entrySet()) {
            builderContext.setHandlerConfiguration(entry.getKey(), entry.getValue());
        }
        ArrayList<Feature> features = new ArrayList<Feature>();
        byte[] buffer = new byte[0x10000000];
        for (String featureFile : config.getFeatureFiles()) {
            for (String initFile : IOUtils.getFeatureFiles(config.getHomeDirectory(), featureFile)) {
                ArtifactHandler featureArtifact;
                if (initFile.endsWith(".far")) {
                    logger.debug("Reading feature archive {}", (Object)initFile);
                    featureArtifact = artifactManager.getArtifactHandler(initFile);
                    try (InputStream is = featureArtifact.getLocalURL().openStream();){
                        for (Feature feature : ArchiveReader.read(is, (id, stream) -> {
                            File artifactFile;
                            if (provider.provide(id) == null && !(artifactFile = new File(config.getCacheDirectory(), id.toMvnPath().replace('/', File.separatorChar))).exists()) {
                                artifactFile.getParentFile().mkdirs();
                                try (FileOutputStream os = new FileOutputStream(artifactFile);){
                                    int l = 0;
                                    while ((l = stream.read(buffer)) > 0) {
                                        ((OutputStream)os).write(buffer, 0, l);
                                    }
                                }
                            }
                        })) {
                            features.add(feature);
                            loadedFeatures.put(feature.getId(), feature);
                        }
                    }
                    catch (IOException ioe) {
                        logger.info("Unable to read feature archive from " + initFile, ioe);
                    }
                    continue;
                }
                logger.debug("Reading feature file {}", (Object)initFile);
                featureArtifact = artifactManager.getArtifactHandler(initFile);
                try (InputStreamReader r = new InputStreamReader(featureArtifact.getLocalURL().openStream(), "UTF-8");){
                    Feature f = FeatureJSONReader.read(r, featureArtifact.getUrl());
                    loadedFeatures.put(f.getId(), f);
                    features.add(f);
                }
                catch (Exception ex) {
                    throw new IOException("Error reading feature: " + initFile, ex);
                }
            }
        }
        Feature app = FeatureBuilder.assemble(ArtifactId.fromMvnId("group:assembled:1.0.0"), builderContext, features.toArray(new Feature[0]));
        loadedFeatures.put(app.getId(), app);
        for (Artifact bundle : app.getBundles()) {
            if (bundle.getStartOrder() != 0) continue;
            int so = bundle.getMetadata().get("start-level") != null ? Integer.parseInt(bundle.getMetadata().get("start-level")) : 1;
            bundle.setStartOrder(so);
        }
        FeatureBuilder.resolveVariables(app, config.getVariables());
        return app;
    }

    public static void prepareLauncher(LauncherPrepareContext ctx, LauncherConfig config, Feature app, Map<ArtifactId, Feature> loadedFeatures) throws Exception {
        for (Map.Entry<Integer, List<Artifact>> entry : app.getBundles().getBundlesByStartOrder().entrySet()) {
            for (Artifact a : entry.getValue()) {
                URL artifactFile = ctx.getArtifactFile(a.getId());
                config.getInstallation().addBundle(entry.getKey(), artifactFile);
            }
        }
        for (Configuration configuration : app.getConfigurations()) {
            if (Configuration.isFactoryConfiguration(configuration.getPid())) {
                config.getInstallation().addConfiguration(Configuration.getName(configuration.getPid()), Configuration.getFactoryPid(configuration.getPid()), configuration.getConfigurationProperties());
                continue;
            }
            config.getInstallation().addConfiguration(configuration.getPid(), null, configuration.getConfigurationProperties());
        }
        for (Map.Entry<Object, Object> entry : app.getFrameworkProperties().entrySet()) {
            if (config.getInstallation().getFrameworkProperties().containsKey(entry.getKey())) continue;
            config.getInstallation().getFrameworkProperties().put((String)entry.getKey(), (String)entry.getValue());
        }
        block4: for (Extension extension : app.getExtensions()) {
            for (ExtensionHandler handler : ServiceLoader.load(ExtensionHandler.class, FeatureProcessor.class.getClassLoader())) {
                if (!handler.handle(new ExtensionContextImpl(ctx, config.getInstallation(), loadedFeatures), extension)) continue;
                continue block4;
            }
            if (extension.getState() != ExtensionState.REQUIRED) continue;
            throw new Exception("Unknown required extension " + extension.getName());
        }
    }
}

