/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.launcher.impl.launchers;

import java.net.URL;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.sling.feature.launcher.impl.launchers.AbstractRunner;
import org.osgi.framework.BundleException;
import org.osgi.framework.FrameworkEvent;
import org.osgi.framework.launch.Framework;
import org.osgi.framework.launch.FrameworkFactory;

public class FrameworkRunner
extends AbstractRunner {
    private static final String START_TIMEOUT = "sling.framework.start.timeout";
    private static final String SHUTDOWN_GRACE_TIME = "sling.framework.shutdown.graceTime";
    private volatile int type = -1;

    public FrameworkRunner(Map<String, String> frameworkProperties, Map<Integer, List<URL>> bundlesMap, List<Object[]> configurations, List<URL> installables) throws Exception {
        super(configurations, installables);
        ServiceLoader<FrameworkFactory> loader = ServiceLoader.load(FrameworkFactory.class);
        FrameworkFactory factory = null;
        Iterator<FrameworkFactory> iterator = loader.iterator();
        if (iterator.hasNext()) {
            FrameworkFactory f;
            factory = f = iterator.next();
        }
        if (factory == null) {
            throw new Exception("Unable to locate framework factory.");
        }
        final Framework framework = factory.newFramework(frameworkProperties);
        framework.init();
        final long graceTime = Long.parseLong(frameworkProperties.getOrDefault(SHUTDOWN_GRACE_TIME, "60"));
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                try {
                    framework.stop();
                    FrameworkEvent waitForStop = framework.waitForStop(graceTime * 1000L);
                    if (waitForStop.getType() != 64) {
                        FrameworkRunner.this.logger.warn("Framework stopped with: " + waitForStop.getType(), waitForStop.getThrowable());
                    } else {
                        FrameworkRunner.this.logger.info("Framework stopped");
                    }
                }
                catch (InterruptedException | BundleException e) {
                    FrameworkRunner.this.logger.warn("Exception stopping the framework in shutdown hook", e);
                }
            }
        });
        this.setupFramework(framework, bundlesMap);
        long time = System.currentTimeMillis();
        long startTimeout = Long.parseLong(frameworkProperties.getOrDefault(START_TIMEOUT, String.valueOf(600)));
        if (!this.startFramework(framework, startTimeout, TimeUnit.SECONDS)) {
            throw new TimeoutException("Waited for more than " + startTimeout + " seconds to startup framework.");
        }
        this.logger.info("Framework started");
        this.logger.debug("Startup took: " + (System.currentTimeMillis() - time));
        while ((this.type = framework.waitForStop(Long.MAX_VALUE).getType()) == 128) {
            this.logger.info("Framework restart due to update");
            time = System.currentTimeMillis();
            if (!this.startFramework(framework, startTimeout, TimeUnit.SECONDS)) {
                throw new TimeoutException("Waited for more than " + startTimeout + " seconds to startup framework.");
            }
            this.logger.debug("Restart took: " + (System.currentTimeMillis() - time));
        }
    }

    @Override
    public Integer call() {
        return this.type;
    }
}

