/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements. See the NOTICE file distributed with this
 * work for additional information regarding copyright ownership. The ASF
 * licenses this file to You under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package org.apache.sling.feature.io.json;

import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Iterator;

import javax.json.stream.JsonGenerator;

import org.apache.sling.feature.Configuration;
import org.apache.sling.feature.Configurations;

/** JSON writer for configurations */
public class ConfigurationJSONWriter extends JSONWriterBase {

    /** Writes the configurations to the writer. The writer is not closed.
     * 
     * @param writer Writer
     * @param configs List of configurations
     * @throws IOException If writing fails */
    public static void write(final Writer writer, final Configurations configs)
            throws IOException {
        final ConfigurationJSONWriter w = new ConfigurationJSONWriter();
        w.writeConfigurations(writer, configs);
    }

    private void writeConfigurations(final Writer writer, final Configurations configs)
            throws IOException {
        JsonGenerator generator = newGenerator(writer);
        writeConfigurations(generator, configs);
        generator.close();
    }

    
}
