/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.io.json;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.felix.utils.resource.CapabilityImpl;
import org.osgi.framework.BundleException;
import org.osgi.framework.Version;
import org.osgi.resource.Capability;

class ManifestUtils {
    private static final char EOF = '\uffff';
    private static final int CLAUSE_START = 0;
    private static final int PARAMETER_START = 1;
    private static final int KEY = 2;
    private static final int DIRECTIVE_OR_TYPEDATTRIBUTE = 4;
    private static final int ARGUMENT = 8;
    private static final int VALUE = 16;

    ManifestUtils() {
    }

    public static void unmarshalAttribute(String key, Object value, BiConsumer<String, Object> sink) throws IOException {
        ManifestUtils.unmarshal(key + "=" + value, Capability::getAttributes, sink);
    }

    public static void unmarshalDirective(String key, Object value, BiConsumer<String, String> sink) throws IOException {
        ManifestUtils.unmarshal(key + ":=" + value, Capability::getDirectives, sink);
    }

    private static <T> void unmarshal(String header, Function<Capability, Map<String, T>> lookup, BiConsumer<String, T> sink) throws IOException {
        try {
            ManifestUtils.convertProvideCapabilities(ManifestUtils.normalizeCapabilityClauses(ManifestUtils.parseStandardHeader("foo;" + header), "2")).forEach(capability -> ((Map)lookup.apply((Capability)capability)).forEach(sink));
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    public static void marshalAttribute(String key, Object value, BiConsumer<String, String> sink) {
        ManifestUtils.marshal(key, value, sink);
    }

    public static void marshalDirective(String key, Object value, BiConsumer<String, String> sink) {
        ManifestUtils.marshal(key, value, sink);
    }

    private static void marshal(String key, Object value, BiConsumer<String, String> sink) {
        StringBuilder keyBuilder = new StringBuilder(key);
        if (value instanceof List) {
            List list = (List)value;
            keyBuilder.append(":List");
            if (!list.isEmpty()) {
                String type = ManifestUtils.type(list.get(0));
                if (!type.equals("String")) {
                    keyBuilder.append('<').append(type).append('>');
                }
                value = list.stream().map(v -> v.toString().replace(",", "\\,")).collect(Collectors.joining(","));
            } else {
                value = "";
            }
        } else {
            String type = ManifestUtils.type(value);
            if (!type.equals("String")) {
                keyBuilder.append(':').append(type);
            }
        }
        sink.accept(keyBuilder.toString(), value.toString());
    }

    private static String type(Object value) {
        if (value instanceof Long) {
            return "Long";
        }
        if (value instanceof Double) {
            return "Double";
        }
        if (value instanceof Version) {
            return "Version";
        }
        return "String";
    }

    public static List<Capability> convertProvideCapabilities(List<ParsedHeaderClause> clauses) throws BundleException {
        ArrayList<Capability> capList = new ArrayList<Capability>();
        for (ParsedHeaderClause clause : clauses) {
            for (String path : clause.m_paths) {
                if (path.startsWith("osgi.wiring.")) {
                    throw new BundleException("Manifest cannot use Provide-Capability for '" + path + "' namespace.");
                }
                CapabilityImpl capability = new CapabilityImpl(null, path, clause.m_dirs, clause.m_attrs);
                capList.add(capability);
            }
        }
        return capList;
    }

    public static List<ParsedHeaderClause> normalizeCapabilityClauses(List<ParsedHeaderClause> clauses, String mv) throws BundleException {
        if (mv.equals("2") || !clauses.isEmpty()) {
            // empty if block
        }
        for (ParsedHeaderClause clause : clauses) {
            for (Map.Entry<String, String> entry : clause.m_types.entrySet()) {
                String type = entry.getValue();
                if (type.equals("String")) continue;
                if (type.equals("Double")) {
                    clause.m_attrs.put(entry.getKey(), new Double(clause.m_attrs.get(entry.getKey()).toString().trim()));
                    continue;
                }
                if (type.equals("Version")) {
                    clause.m_attrs.put(entry.getKey(), new Version(clause.m_attrs.get(entry.getKey()).toString().trim()));
                    continue;
                }
                if (type.equals("Long")) {
                    clause.m_attrs.put(entry.getKey(), new Long(clause.m_attrs.get(entry.getKey()).toString().trim()));
                    continue;
                }
                if (type.startsWith("List")) {
                    int startIdx = type.indexOf(60);
                    int endIdx = type.indexOf(62);
                    if (startIdx > 0 && endIdx <= startIdx || startIdx < 0 && endIdx > 0) {
                        throw new BundleException("Invalid Provide-Capability attribute list type for '" + entry.getKey() + "' : " + type);
                    }
                    String listType = "String";
                    if (endIdx > startIdx) {
                        listType = type.substring(startIdx + 1, endIdx).trim();
                    }
                    List<String> tokens = ManifestUtils.parseDelimitedString(clause.m_attrs.get(entry.getKey()).toString(), ",", false);
                    ArrayList<Object> values = new ArrayList<Object>(tokens.size());
                    for (String token : tokens) {
                        if (listType.equals("String")) {
                            values.add(token);
                            continue;
                        }
                        if (listType.equals("Double")) {
                            values.add(new Double(token.trim()));
                            continue;
                        }
                        if (listType.equals("Version")) {
                            values.add(new Version(token.trim()));
                            continue;
                        }
                        if (listType.equals("Long")) {
                            values.add(new Long(token.trim()));
                            continue;
                        }
                        throw new BundleException("Unknown Provide-Capability attribute list type for '" + entry.getKey() + "' : " + type);
                    }
                    clause.m_attrs.put(entry.getKey(), values);
                    continue;
                }
                throw new BundleException("Unknown Provide-Capability attribute type for '" + entry.getKey() + "' : " + type);
            }
        }
        return clauses;
    }

    private static char charAt(int pos, String headers, int length) {
        if (pos >= length) {
            return '\uffff';
        }
        return headers.charAt(pos);
    }

    public static List<ParsedHeaderClause> parseStandardHeader(String header) {
        ArrayList<ParsedHeaderClause> clauses = new ArrayList<ParsedHeaderClause>();
        if (header == null) {
            return clauses;
        }
        ParsedHeaderClause clause = null;
        String key = null;
        Map<String, Object> targetMap = null;
        int state = 0;
        int currentPosition = 0;
        int startPosition = 0;
        int length = header.length();
        boolean quoted = false;
        boolean escaped = false;
        char currentChar = '\uffff';
        do {
            currentChar = ManifestUtils.charAt(currentPosition, header, length);
            switch (state) {
                case 0: {
                    clause = new ParsedHeaderClause(new ArrayList<String>(), new HashMap<String, String>(), new HashMap<String, Object>(), new HashMap<String, String>());
                    clauses.add(clause);
                    state = 1;
                }
                case 1: {
                    startPosition = currentPosition;
                    state = 2;
                }
                case 2: {
                    switch (currentChar) {
                        case ':': 
                        case '=': {
                            key = header.substring(startPosition, currentPosition).trim();
                            startPosition = currentPosition + 1;
                            targetMap = clause.m_attrs;
                            state = currentChar == ':' ? 4 : 8;
                            break;
                        }
                        case ',': 
                        case ';': 
                        case '\uffff': {
                            clause.m_paths.add(header.substring(startPosition, currentPosition).trim());
                            state = currentChar == ',' ? 0 : 1;
                            break;
                        }
                    }
                    ++currentPosition;
                    break;
                }
                case 4: {
                    switch (currentChar) {
                        case '=': {
                            if (startPosition != currentPosition) {
                                clause.m_types.put(key, header.substring(startPosition, currentPosition).trim());
                            } else {
                                targetMap = clause.m_dirs;
                            }
                            state = 8;
                            startPosition = currentPosition + 1;
                            break;
                        }
                    }
                    ++currentPosition;
                    break;
                }
                case 8: {
                    if (currentChar == '\"') {
                        quoted = true;
                        ++currentPosition;
                    } else {
                        quoted = false;
                    }
                    if (!Character.isWhitespace(currentChar)) {
                        state = 16;
                        break;
                    }
                    ++currentPosition;
                    break;
                }
                case 16: {
                    if (escaped) {
                        escaped = false;
                    } else if (currentChar == '\\') {
                        escaped = true;
                    } else if (quoted && currentChar == '\"') {
                        quoted = false;
                    } else if (!quoted) {
                        String value = null;
                        switch (currentChar) {
                            case ',': 
                            case ';': 
                            case '\uffff': {
                                value = header.substring(startPosition, currentPosition).trim();
                                if (value.startsWith("\"") && value.endsWith("\"")) {
                                    value = value.substring(1, value.length() - 1);
                                }
                                if (targetMap.put(key, value) != null) {
                                    throw new IllegalArgumentException("Duplicate '" + key + "' in: " + header);
                                }
                                state = currentChar == ';' ? 1 : 0;
                                break;
                            }
                        }
                    }
                    ++currentPosition;
                    break;
                }
            }
        } while (currentChar != 65535);
        if (state > 1) {
            throw new IllegalArgumentException("Unable to parse header: " + header);
        }
        return clauses;
    }

    public static List<String> parseDelimitedString(String value, String delim, boolean trim) {
        if (value == null) {
            value = "";
        }
        ArrayList<String> list = new ArrayList<String>();
        int CHAR = 1;
        int DELIMITER = 2;
        int STARTQUOTE = 4;
        int ENDQUOTE = 8;
        StringBuffer sb = new StringBuffer();
        int expecting = CHAR | DELIMITER | STARTQUOTE;
        boolean isEscaped = false;
        for (int i = 0; i < value.length(); ++i) {
            boolean isDelimiter;
            char c = value.charAt(i);
            boolean bl = isDelimiter = delim.indexOf(c) >= 0;
            if (!isEscaped && c == '\\') {
                isEscaped = true;
                continue;
            }
            if (isEscaped) {
                sb.append(c);
            } else if (isDelimiter && (expecting & DELIMITER) > 0) {
                if (trim) {
                    list.add(sb.toString().trim());
                } else {
                    list.add(sb.toString());
                }
                sb.delete(0, sb.length());
                expecting = CHAR | DELIMITER | STARTQUOTE;
            } else if (c == '\"' && (expecting & STARTQUOTE) > 0) {
                sb.append(c);
                expecting = CHAR | ENDQUOTE;
            } else if (c == '\"' && (expecting & ENDQUOTE) > 0) {
                sb.append(c);
                expecting = CHAR | STARTQUOTE | DELIMITER;
            } else if ((expecting & CHAR) > 0) {
                sb.append(c);
            } else {
                throw new IllegalArgumentException("Invalid delimited string: " + value);
            }
            isEscaped = false;
        }
        if (sb.length() > 0) {
            if (trim) {
                list.add(sb.toString().trim());
            } else {
                list.add(sb.toString());
            }
        }
        return list;
    }

    static class ParsedHeaderClause {
        public final List<String> m_paths;
        public final Map<String, String> m_dirs;
        public final Map<String, Object> m_attrs;
        public final Map<String, String> m_types;

        public ParsedHeaderClause(List<String> paths, Map<String, String> dirs, Map<String, Object> attrs, Map<String, String> types) {
            this.m_paths = paths;
            this.m_dirs = dirs;
            this.m_attrs = attrs;
            this.m_types = types;
        }
    }
}

