/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.io.file;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import org.apache.sling.feature.io.file.spi.ArtifactProviderContext;

public class ArtifactManagerConfig
implements ArtifactProviderContext {
    private volatile String[] repositoryUrls = new String[]{"file://" + new File(System.getProperty("user.home")).toURI().getPath() + ".m2/repository", "https://repo.maven.apache.org/maven2", "https://repository.apache.org/content/groups/snapshots"};
    private volatile File cacheDirectory;
    private volatile long cachedArtifacts;
    private volatile long downloadedArtifacts;
    private volatile long localArtifacts;

    public ArtifactManagerConfig() {
        try {
            this.cacheDirectory = Files.createTempDirectory("slingfeature", new FileAttribute[0]).toFile();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void setRepositoryUrls(String[] urls) {
        if (urls == null || urls.length == 0) {
            this.repositoryUrls = null;
        } else {
            this.repositoryUrls = new String[urls.length];
            System.arraycopy(urls, 0, this.repositoryUrls, 0, urls.length);
            for (int i = 0; i < this.repositoryUrls.length; ++i) {
                if (!this.repositoryUrls[i].endsWith("/")) continue;
                this.repositoryUrls[i] = this.repositoryUrls[i].substring(0, this.repositoryUrls[i].length() - 1);
            }
        }
    }

    public String[] getRepositoryUrls() {
        return this.repositoryUrls;
    }

    @Override
    public File getCacheDirectory() {
        return this.cacheDirectory;
    }

    public void setCacheDirectory(File dir) {
        this.cacheDirectory = dir;
    }

    @Override
    public void incCachedArtifacts() {
        ++this.cachedArtifacts;
    }

    @Override
    public void incDownloadedArtifacts() {
        ++this.downloadedArtifacts;
    }

    @Override
    public void incLocalArtifacts() {
        ++this.localArtifacts;
    }

    public long getCachedArtifacts() {
        return this.cachedArtifacts;
    }

    public long getDownloadedArtifacts() {
        return this.downloadedArtifacts;
    }

    public long getLocalArtifacts() {
        return this.localArtifacts;
    }
}

