/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.io.json;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.json.Json;
import javax.json.JsonObject;
import org.apache.felix.utils.resource.CapabilityImpl;
import org.apache.felix.utils.resource.RequirementImpl;
import org.apache.sling.feature.ArtifactId;
import org.apache.sling.feature.Feature;
import org.apache.sling.feature.Include;
import org.apache.sling.feature.KeyValueMap;
import org.apache.sling.feature.io.json.JSONConstants;
import org.apache.sling.feature.io.json.JSONReaderBase;
import org.apache.sling.feature.io.json.ManifestUtils;

public class FeatureJSONReader
extends JSONReaderBase {
    private static final Pattern VARIABLE_PATTERN = Pattern.compile("\\$\\{[a-zA-Z0-9.-_]+\\}");
    private Feature feature;
    private final ArtifactId providedId;
    private Map<String, String> variables;
    private final SubstituteVariables phase;

    public static Feature read(Reader reader, String location, SubstituteVariables phase) throws IOException {
        return FeatureJSONReader.read(reader, null, location, phase);
    }

    public static Feature read(Reader reader, ArtifactId providedId, String location, SubstituteVariables phase) throws IOException {
        try {
            FeatureJSONReader mr = new FeatureJSONReader(providedId, location, phase);
            return mr.readFeature(reader);
        }
        catch (IllegalArgumentException | IllegalStateException e) {
            throw new IOException(e);
        }
    }

    FeatureJSONReader(ArtifactId pId, String location, SubstituteVariables phase) {
        super(location);
        this.providedId = pId;
        this.phase = phase;
    }

    private Feature readFeature(Reader reader) throws IOException {
        ArtifactId fId;
        JsonObject json = Json.createReader((Reader)new StringReader(this.minify(reader))).readObject();
        Map<String, Object> map = this.getJsonMap(json);
        this.checkModelVersion(map);
        if (!map.containsKey("id")) {
            if (this.providedId == null) {
                throw new IOException(this.exceptionPrefix + "Feature id is missing");
            }
            fId = this.providedId;
        } else {
            Object idObj = map.get("id");
            this.checkType("id", idObj, String.class);
            fId = ArtifactId.parse((String)idObj.toString());
        }
        this.feature = new Feature(fId);
        this.feature.setLocation(this.location);
        this.feature.setTitle(this.getProperty(map, "title"));
        this.feature.setDescription(this.getProperty(map, "description"));
        this.feature.setVendor(this.getProperty(map, "vendor"));
        this.feature.setLicense(this.getProperty(map, "license"));
        this.readVariables(map, this.feature.getVariables());
        this.readBundles(map, this.feature.getBundles(), this.feature.getConfigurations());
        this.readFrameworkProperties(map, this.feature.getFrameworkProperties());
        this.readConfigurations(map, this.feature.getConfigurations());
        this.readCapabilities(map);
        this.readRequirements(map);
        this.readIncludes(map);
        this.readExtensions(map, JSONConstants.FEATURE_KNOWN_PROPERTIES, this.feature.getExtensions(), this.feature.getConfigurations());
        return this.feature;
    }

    private void checkModelVersion(Map<String, Object> map) throws IOException {
        String modelVersion = this.getProperty(map, "model-version");
        if (modelVersion == null) {
            modelVersion = "1";
        }
        if (!"1".equals(modelVersion)) {
            throw new IOException("Unsupported model version: " + modelVersion);
        }
    }

    @Override
    protected Object handleResolveVars(Object val) {
        if (this.phase == SubstituteVariables.RESOLVE) {
            return this.handleVars(val);
        }
        return val;
    }

    @Override
    protected Object handleLaunchVars(Object val) {
        if (this.phase == SubstituteVariables.LAUNCH) {
            return this.handleVars(val);
        }
        return val;
    }

    private Object handleVars(Object value) {
        if (!(value instanceof String)) {
            return value;
        }
        String textWithVars = (String)value;
        Matcher m = VARIABLE_PATTERN.matcher(textWithVars.toString());
        StringBuffer sb = new StringBuffer();
        while (m.find()) {
            int len;
            String var = m.group();
            String name = var.substring(2, (len = var.length()) - 1);
            String val = this.variables.get(name);
            if (val != null) {
                m.appendReplacement(sb, Matcher.quoteReplacement(val));
                continue;
            }
            throw new IllegalStateException("Undefined variable: " + name);
        }
        m.appendTail(sb);
        return sb.toString();
    }

    private void readVariables(Map<String, Object> map, KeyValueMap kvMap) throws IOException {
        this.variables = new HashMap<String, String>();
        if (map.containsKey("variables")) {
            Object variablesObj = map.get("variables");
            this.checkType("variables", variablesObj, Map.class);
            Map vars = (Map)variablesObj;
            for (Map.Entry entry : vars.entrySet()) {
                this.checkType("variable value", entry.getValue(), String.class, Boolean.class, Number.class);
                String key = (String)entry.getKey();
                if (kvMap.get(key) != null) {
                    throw new IOException(this.exceptionPrefix + "Duplicate variable " + key);
                }
                String value = "" + entry.getValue();
                kvMap.put(key, (Object)value);
                this.variables.put(key, value);
            }
        }
    }

    private void readIncludes(Map<String, Object> map) throws IOException {
        if (map.containsKey("includes")) {
            Object includesObj = map.get("includes");
            this.checkType("includes", includesObj, List.class);
            List includes = (List)includesObj;
            for (Object inc : includes) {
                Include include;
                this.checkType("Include", inc, Map.class, String.class);
                if (inc instanceof String) {
                    ArtifactId id = ArtifactId.parse((String)inc.toString());
                    include = new Include(id);
                } else {
                    Map obj = (Map)inc;
                    if (!obj.containsKey("id")) {
                        throw new IOException(this.exceptionPrefix + " include is missing required artifact id");
                    }
                    this.checkType("Include id", obj.get("id"), String.class);
                    ArtifactId id = ArtifactId.parse((String)this.handleResolveVars(obj.get("id")).toString());
                    include = new Include(id);
                    if (obj.containsKey("removals")) {
                        List list;
                        this.checkType("Include removals", obj.get("removals"), Map.class);
                        Map removalObj = (Map)obj.get("removals");
                        if (removalObj.containsKey("bundles")) {
                            this.checkType("Include removal bundles", removalObj.get("bundles"), List.class);
                            list = (List)removalObj.get("bundles");
                            for (Object val : list) {
                                this.checkType("Include removal bundles", val, String.class);
                                include.getBundleRemovals().add(ArtifactId.parse((String)val.toString()));
                            }
                        }
                        if (removalObj.containsKey("configurations")) {
                            this.checkType("Include removal configuration", removalObj.get("configurations"), List.class);
                            list = (List)removalObj.get("configurations");
                            for (Object val : list) {
                                this.checkType("Include removal bundles", val, String.class);
                                include.getConfigurationRemovals().add(val.toString());
                            }
                        }
                        if (removalObj.containsKey("framework-properties")) {
                            this.checkType("Include removal framework properties", removalObj.get("framework-properties"), List.class);
                            list = (List)removalObj.get("framework-properties");
                            for (Object val : list) {
                                this.checkType("Include removal bundles", val, String.class);
                                include.getFrameworkPropertiesRemovals().add(val.toString());
                            }
                        }
                        if (removalObj.containsKey("extensions")) {
                            this.checkType("Include removal extensions", removalObj.get("extensions"), List.class);
                            list = (List)removalObj.get("extensions");
                            for (Object val : list) {
                                this.checkType("Include removal extension", val, String.class, Map.class);
                                if (val instanceof String) {
                                    include.getExtensionRemovals().add(val.toString());
                                    continue;
                                }
                                Map removalMap = (Map)val;
                                Object nameObj = removalMap.get("name");
                                this.checkType("Include removal extension", nameObj, String.class);
                                if (removalMap.containsKey("artifacts")) {
                                    this.checkType("Include removal extension artifacts", removalMap.get("artifacts"), List.class);
                                    List artifactList = (List)removalMap.get("artifacts");
                                    ArrayList<ArtifactId> ids = new ArrayList<ArtifactId>();
                                    for (Object aid : artifactList) {
                                        this.checkType("Include removal extension artifact", aid, String.class);
                                        ids.add(ArtifactId.parse((String)aid.toString()));
                                    }
                                    include.getArtifactExtensionRemovals().put(nameObj.toString(), ids);
                                    continue;
                                }
                                include.getExtensionRemovals().add(nameObj.toString());
                            }
                        }
                    }
                }
                for (Include i : this.feature.getIncludes()) {
                    if (!i.getId().equals((Object)include.getId())) continue;
                    throw new IOException(this.exceptionPrefix + "Duplicate include of " + include.getId());
                }
                this.feature.getIncludes().add(include);
            }
        }
    }

    private void readRequirements(Map<String, Object> map) throws IOException {
        if (map.containsKey("requirements")) {
            Object reqObj = map.get("requirements");
            this.checkType("requirements", reqObj, List.class);
            List requirements = (List)reqObj;
            for (Object req : requirements) {
                this.checkType("Requirement", req, Map.class);
                Map obj = (Map)req;
                if (!obj.containsKey("namespace")) {
                    throw new IOException(this.exceptionPrefix + "Namespace is missing for requirement");
                }
                this.checkType("Requirement namespace", obj.get("namespace"), String.class);
                HashMap attrMap = new HashMap();
                if (obj.containsKey("attributes")) {
                    this.checkType("Requirement attributes", obj.get("attributes"), Map.class);
                    Map attrs = (Map)obj.get("attributes");
                    attrs.forEach(FeatureJSONReader.rethrowBiConsumer((key, value) -> ManifestUtils.unmarshalAttribute(key, this.handleResolveVars(value), attrMap::put)));
                }
                HashMap dirMap = new HashMap();
                if (obj.containsKey("directives")) {
                    this.checkType("Requirement directives", obj.get("directives"), Map.class);
                    Map dirs = (Map)obj.get("directives");
                    dirs.forEach(FeatureJSONReader.rethrowBiConsumer((key, value) -> ManifestUtils.unmarshalDirective(key, this.handleResolveVars(value), dirMap::put)));
                }
                RequirementImpl r = new RequirementImpl(null, this.handleResolveVars(obj.get("namespace")).toString(), dirMap, attrMap);
                this.feature.getRequirements().add(r);
            }
        }
    }

    private void readCapabilities(Map<String, Object> map) throws IOException {
        if (map.containsKey("capabilities")) {
            Object capObj = map.get("capabilities");
            this.checkType("capabilities", capObj, List.class);
            List capabilities = (List)capObj;
            for (Object cap : capabilities) {
                this.checkType("Capability", cap, Map.class);
                Map obj = (Map)cap;
                if (!obj.containsKey("namespace")) {
                    throw new IOException(this.exceptionPrefix + "Namespace is missing for capability");
                }
                this.checkType("Capability namespace", obj.get("namespace"), String.class);
                HashMap attrMap = new HashMap();
                if (obj.containsKey("attributes")) {
                    this.checkType("Capability attributes", obj.get("attributes"), Map.class);
                    Map attrs = (Map)obj.get("attributes");
                    attrs.forEach(FeatureJSONReader.rethrowBiConsumer((key, value) -> ManifestUtils.unmarshalAttribute(key, this.handleResolveVars(value), attrMap::put)));
                }
                HashMap dirMap = new HashMap();
                if (obj.containsKey("directives")) {
                    this.checkType("Capability directives", obj.get("directives"), Map.class);
                    Map dirs = (Map)obj.get("directives");
                    dirs.forEach(FeatureJSONReader.rethrowBiConsumer((key, value) -> ManifestUtils.unmarshalDirective(key, this.handleResolveVars(value), dirMap::put)));
                }
                CapabilityImpl c = new CapabilityImpl(null, this.handleResolveVars(obj.get("namespace")).toString(), dirMap, attrMap);
                this.feature.getCapabilities().add(c);
            }
        }
    }

    private static <T, V, E extends Exception> BiConsumer<T, V> rethrowBiConsumer(BiConsumer_WithExceptions<T, V, E> biConsumer) {
        return (t, u) -> {
            try {
                biConsumer.accept(t, u);
            }
            catch (Exception exception) {
                FeatureJSONReader.throwAsUnchecked(exception);
            }
        };
    }

    private static <E extends Throwable> void throwAsUnchecked(Exception exception) throws E {
        throw exception;
    }

    @FunctionalInterface
    private static interface BiConsumer_WithExceptions<T, V, E extends Exception> {
        public void accept(T var1, V var2) throws E;
    }

    public static enum SubstituteVariables {
        NONE,
        RESOLVE,
        LAUNCH;

    }
}

