/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.io.json;

import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Array;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import javax.json.Json;
import javax.json.JsonArrayBuilder;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonStructure;
import javax.json.JsonValue;
import org.apache.sling.feature.Artifact;
import org.apache.sling.feature.Bundles;
import org.apache.sling.feature.Configuration;
import org.apache.sling.feature.Configurations;
import org.apache.sling.feature.Extension;
import org.apache.sling.feature.ExtensionType;
import org.apache.sling.feature.KeyValueMap;

abstract class JSONWriterBase {
    JSONWriterBase() {
    }

    protected void writeBundles(JsonObjectBuilder ob, Bundles bundles, Configurations allConfigs) {
        if (!bundles.isEmpty()) {
            JsonArrayBuilder bundleArray = Json.createArrayBuilder();
            for (Artifact artifact : bundles) {
                Object runmodes;
                String so;
                Configurations cfgs = new Configurations();
                for (Configuration cfg : allConfigs) {
                    String artifactProp = (String)cfg.getProperties().get("service.bundleLocation");
                    if (artifactProp == null) continue;
                    if (artifactProp.startsWith("mvn:")) {
                        artifactProp = artifactProp.substring("mvn:".length());
                        artifactProp = artifactProp.replace('/', ':');
                    }
                    if (!artifact.getId().toMvnId().equals(artifactProp)) continue;
                    cfgs.add((Object)cfg);
                }
                KeyValueMap md = artifact.getMetadata();
                if (md.isEmpty() && cfgs.isEmpty()) {
                    bundleArray.add(artifact.getId().toMvnId());
                    continue;
                }
                JsonObjectBuilder bundleObj = Json.createObjectBuilder();
                bundleObj.add("id", artifact.getId().toMvnId());
                if (md.get("start-level") == null && (so = md.get("start-order")) != null) {
                    md.put("start-level", (Object)so);
                }
                if ((runmodes = md.remove("runmodes")) instanceof String) {
                    md.put("run-modes", runmodes);
                }
                for (Map.Entry me : md) {
                    bundleObj.add((String)me.getKey(), (String)me.getValue());
                }
                this.writeConfigurations(bundleObj, cfgs);
                bundleArray.add((JsonValue)bundleObj.build());
            }
            ob.add("bundles", (JsonValue)bundleArray.build());
        }
    }

    protected void writeConfigurations(JsonObjectBuilder ob, Configurations cfgs) {
        if (!cfgs.isEmpty()) {
            ob.add("configurations", (JsonValue)this.writeConfigurationsMap(cfgs));
        }
    }

    protected JsonObject writeConfigurationsMap(Configurations cfgs) {
        JsonObjectBuilder configObj = Json.createObjectBuilder();
        for (Configuration cfg : cfgs) {
            String key = cfg.isFactoryConfiguration() ? cfg.getFactoryPid() + "~" + cfg.getName() : cfg.getPid();
            JsonObjectBuilder cfgValObj = Json.createObjectBuilder();
            Enumeration e = cfg.getProperties().keys();
            while (e.hasMoreElements()) {
                String name = (String)e.nextElement();
                if ("service.bundleLocation".equals(name)) continue;
                Object val = cfg.getProperties().get(name);
                String typePostFix = null;
                Object typeCheck = val.getClass().isArray() ? (Array.getLength(val) > 0 ? Array.get(val, 0) : null) : val;
                if (typeCheck instanceof Integer) {
                    typePostFix = ":Integer";
                } else if (typeCheck instanceof Byte) {
                    typePostFix = ":Byte";
                } else if (typeCheck instanceof Character) {
                    typePostFix = ":Character";
                } else if (typeCheck instanceof Float) {
                    typePostFix = ":Float";
                }
                if (val.getClass().isArray()) {
                    JsonArrayBuilder ab = Json.createArrayBuilder();
                    for (int i = 0; i < Array.getLength(val); ++i) {
                        Object obj = Array.get(val, i);
                        if (typePostFix == null) {
                            if (obj instanceof String) {
                                ab.add((String)obj);
                                continue;
                            }
                            if (obj instanceof Boolean) {
                                ab.add(((Boolean)obj).booleanValue());
                                continue;
                            }
                            if (obj instanceof Long) {
                                ab.add(((Long)obj).longValue());
                                continue;
                            }
                            if (!(obj instanceof Double)) continue;
                            ab.add(((Double)obj).doubleValue());
                            continue;
                        }
                        ab.add(obj.toString());
                    }
                    cfgValObj.add(name, (JsonValue)ab.build());
                    continue;
                }
                if (typePostFix == null) {
                    if (val instanceof String) {
                        cfgValObj.add(name, (String)val);
                        continue;
                    }
                    if (val instanceof Boolean) {
                        cfgValObj.add(name, ((Boolean)val).booleanValue());
                        continue;
                    }
                    if (val instanceof Long) {
                        cfgValObj.add(name, ((Long)val).longValue());
                        continue;
                    }
                    if (!(val instanceof Double)) continue;
                    cfgValObj.add(name, ((Double)val).doubleValue());
                    continue;
                }
                cfgValObj.add(name + typePostFix, val.toString());
            }
            configObj.add(key, (JsonValue)cfgValObj.build());
        }
        return configObj.build();
    }

    protected void writeVariables(JsonObjectBuilder ob, KeyValueMap vars) {
        if (!vars.isEmpty()) {
            JsonObjectBuilder varsObj = Json.createObjectBuilder();
            for (Map.Entry entry : vars) {
                varsObj.add((String)entry.getKey(), (String)entry.getValue());
            }
            ob.add("variables", (JsonValue)varsObj.build());
        }
    }

    protected void writeFrameworkProperties(JsonObjectBuilder ob, KeyValueMap props) {
        if (!props.isEmpty()) {
            JsonObjectBuilder propsObj = Json.createObjectBuilder();
            for (Map.Entry entry : props) {
                propsObj.add((String)entry.getKey(), (String)entry.getValue());
            }
            ob.add("framework-properties", (JsonValue)propsObj.build());
        }
    }

    protected void writeExtensions(JsonObjectBuilder ob, List<Extension> extensions, Configurations allConfigs) {
        for (Extension ext : extensions) {
            String key = ext.getName() + ":" + ext.getType().name() + "|" + ext.isOptional();
            if (ext.getType() == ExtensionType.JSON) {
                JsonStructure struct;
                try (StringReader reader = new StringReader(ext.getJSON());){
                    struct = Json.createReader((Reader)reader).read();
                }
                ob.add(key, (JsonValue)struct);
                continue;
            }
            if (ext.getType() == ExtensionType.TEXT) {
                ob.add(key, ext.getText());
                continue;
            }
            JsonArrayBuilder extensionArr = Json.createArrayBuilder();
            for (Artifact artifact : ext.getArtifacts()) {
                Configurations artifactCfgs = new Configurations();
                for (Configuration cfg : allConfigs) {
                    String artifactProp = (String)cfg.getProperties().get("service.bundleLocation");
                    if (!artifact.getId().toMvnId().equals(artifactProp)) continue;
                    artifactCfgs.add((Object)cfg);
                }
                if (artifact.getMetadata().isEmpty() && artifactCfgs.isEmpty()) {
                    extensionArr.add(artifact.getId().toMvnId());
                    continue;
                }
                JsonObjectBuilder extObj = Json.createObjectBuilder();
                extObj.add("id", artifact.getId().toMvnId());
                for (Map.Entry me : artifact.getMetadata()) {
                    extObj.add((String)me.getKey(), (String)me.getValue());
                }
                this.writeConfigurations(ob, artifactCfgs);
                extensionArr.add((JsonValue)extObj.build());
            }
            ob.add(key, (JsonValue)extensionArr.build());
        }
    }
}

