/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.io.json;

import java.io.IOException;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.json.Json;
import javax.json.JsonArrayBuilder;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonStructure;
import javax.json.JsonValue;
import org.apache.felix.configurator.impl.json.JSMin;
import org.apache.felix.configurator.impl.json.JSONUtil;
import org.apache.felix.configurator.impl.json.TypeConverter;
import org.apache.felix.configurator.impl.model.Config;
import org.apache.sling.feature.Artifact;
import org.apache.sling.feature.ArtifactId;
import org.apache.sling.feature.Bundles;
import org.apache.sling.feature.Configuration;
import org.apache.sling.feature.Configurations;
import org.apache.sling.feature.Extension;
import org.apache.sling.feature.ExtensionType;
import org.apache.sling.feature.Extensions;
import org.apache.sling.feature.KeyValueMap;
import org.apache.sling.feature.io.json.JSONConstants;

abstract class JSONReaderBase {
    protected final String location;
    protected final String exceptionPrefix;

    JSONReaderBase(String location) {
        this.location = location;
        this.exceptionPrefix = location == null ? "" : location + " : ";
    }

    protected String minify(Reader reader) throws IOException {
        String contents;
        try (StringWriter out = new StringWriter();){
            JSMin min = new JSMin(reader, out);
            min.jsmin();
            contents = ((Object)out).toString();
        }
        return contents;
    }

    protected Map<String, Object> getJsonMap(JsonObject json) {
        Map m = (Map)JSONUtil.getValue((JsonValue)json);
        this.removeComments(m);
        return m;
    }

    private void removeComments(Map<String, Object> m) {
        Iterator<Map.Entry<String, Object>> it = m.entrySet().iterator();
        while (it.hasNext()) {
            Object embedded;
            Map.Entry<String, Object> entry = it.next();
            if (entry.getKey().startsWith("#")) {
                it.remove();
                continue;
            }
            if (entry.getValue() instanceof Map) {
                embedded = (Map)entry.getValue();
                this.removeComments((Map<String, Object>)embedded);
                continue;
            }
            if (!(entry.getValue() instanceof Collection)) continue;
            embedded = (Collection)entry.getValue();
            this.removeComments((Collection<?>)embedded);
        }
    }

    private void removeComments(Collection<?> embedded) {
        for (Object el : embedded) {
            if (el instanceof Collection) {
                this.removeComments((Collection)el);
                continue;
            }
            if (!(el instanceof Map)) continue;
            this.removeComments((Map)el);
        }
    }

    protected String getProperty(Map<String, Object> map, String key) throws IOException {
        Object val = map.get(key);
        if (val != null) {
            this.checkType(key, val, String.class);
            return val.toString();
        }
        return null;
    }

    protected void readBundles(Map<String, Object> map, Bundles container, Configurations configContainer) throws IOException {
        if (map.containsKey("bundles")) {
            Object bundlesObj = map.get("bundles");
            this.checkType("bundles", bundlesObj, List.class);
            ArrayList<Artifact> list = new ArrayList<Artifact>();
            this.readArtifacts("bundles", "bundle", list, bundlesObj, configContainer);
            for (Artifact a : list) {
                Artifact sameFound = container.getSame(a.getId());
                if (sameFound != null) {
                    String str1 = a.getMetadata().get("run-modes");
                    String str2 = sameFound.getMetadata().get("run-modes");
                    if (str1 == null ? str2 == null : str1.equals(str2)) {
                        throw new IOException(this.exceptionPrefix + "Duplicate bundle " + a.getId().toMvnId());
                    }
                }
                try {
                    a.getStartOrder();
                }
                catch (IllegalArgumentException nfe) {
                    throw new IOException(this.exceptionPrefix + "Illegal start order '" + a.getMetadata().get("start-order") + "'");
                }
                container.add(a);
            }
        }
    }

    protected void readArtifacts(String section, String artifactType, List<Artifact> artifacts, Object listObj, Configurations container) throws IOException {
        this.checkType(section, listObj, List.class);
        List list = (List)listObj;
        for (Object entry : list) {
            Artifact artifact;
            this.checkType(artifactType, entry, Map.class, String.class);
            if (entry instanceof String) {
                artifact = new Artifact(ArtifactId.parse((String)this.handleResolveVars(entry).toString()));
            } else {
                Map bundleObj = (Map)entry;
                if (!bundleObj.containsKey("id")) {
                    throw new IOException(this.exceptionPrefix + " " + artifactType + " is missing required artifact id");
                }
                this.checkType(artifactType + " " + "id", bundleObj.get("id"), String.class);
                ArtifactId id = ArtifactId.parse((String)this.handleResolveVars(bundleObj.get("id")).toString());
                artifact = new Artifact(id);
                for (Map.Entry metadataEntry : bundleObj.entrySet()) {
                    String key = (String)metadataEntry.getKey();
                    if (JSONConstants.ARTIFACT_KNOWN_PROPERTIES.contains(key)) continue;
                    this.checkType(artifactType + " metadata " + key, metadataEntry.getValue(), String.class, Number.class, Boolean.class);
                    artifact.getMetadata().put(key, (Object)metadataEntry.getValue().toString());
                }
                if (bundleObj.containsKey("configurations")) {
                    this.checkType(artifactType + " configurations", bundleObj.get("configurations"), Map.class);
                    List<Configuration> bundleConfigs = this.addConfigurations(bundleObj, artifact, container);
                    artifact.getMetadata().put("configurations", bundleConfigs);
                }
            }
            artifacts.add(artifact);
        }
    }

    protected Object handleResolveVars(Object val) {
        return val;
    }

    protected Object handleLaunchVars(Object val) {
        return val;
    }

    protected List<Configuration> addConfigurations(Map<String, Object> map, Artifact artifact, Configurations container) throws IOException {
        JSONUtil.Report report = new JSONUtil.Report();
        List<Config> configs = JSONUtil.readConfigurationsJSON(new TypeConverter(null), 0L, "", (Map)map.get("configurations"), report);
        if (!report.errors.isEmpty() || !report.warnings.isEmpty()) {
            StringBuilder builder = new StringBuilder(this.exceptionPrefix);
            builder.append("Errors in configurations:");
            for (String w : report.warnings) {
                builder.append("\n");
                builder.append(w);
            }
            for (String e : report.errors) {
                builder.append("\n");
                builder.append(e);
            }
            throw new IOException(builder.toString());
        }
        ArrayList<Configuration> newConfigs = new ArrayList<Configuration>();
        for (Config c : configs) {
            int pos = c.getPid().indexOf(126);
            Configuration config = pos != -1 ? new Configuration(c.getPid().substring(0, pos), c.getPid().substring(pos + 1)) : new Configuration(c.getPid());
            Enumeration<String> keyEnum = c.getProperties().keys();
            while (keyEnum.hasMoreElements()) {
                String key = keyEnum.nextElement();
                if (key.startsWith(":configurator:")) {
                    throw new IOException(this.exceptionPrefix + "Configuration must not define configurator property " + key);
                }
                Object val = c.getProperties().get(key);
                config.getProperties().put(key, this.handleLaunchVars(val));
            }
            if (config.getProperties().get("service.bundleLocation") != null) {
                throw new IOException(this.exceptionPrefix + "Configuration must not define property " + "service.bundleLocation");
            }
            if (artifact != null) {
                config.getProperties().put("service.bundleLocation", artifact.getId().toMvnId());
            }
            for (Configuration current : container) {
                if (!current.equals(config)) continue;
                throw new IOException(this.exceptionPrefix + "Duplicate configuration " + config);
            }
            container.add((Object)config);
            newConfigs.add(config);
        }
        return newConfigs;
    }

    protected void readConfigurations(Map<String, Object> map, Configurations container) throws IOException {
        if (map.containsKey("configurations")) {
            this.checkType("configurations", map.get("configurations"), Map.class);
            this.addConfigurations(map, null, container);
        }
    }

    protected void readFrameworkProperties(Map<String, Object> map, KeyValueMap container) throws IOException {
        if (map.containsKey("framework-properties")) {
            Object propsObj = map.get("framework-properties");
            this.checkType("framework-properties", propsObj, Map.class);
            Map props = (Map)propsObj;
            for (Map.Entry entry : props.entrySet()) {
                this.checkType("framework property value", entry.getValue(), String.class, Boolean.class, Number.class);
                if (container.get((String)entry.getKey()) != null) {
                    throw new IOException(this.exceptionPrefix + "Duplicate framework property " + (String)entry.getKey());
                }
                container.put((String)entry.getKey(), (Object)this.handleLaunchVars(entry.getValue()).toString());
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    protected void readExtensions(Map<String, Object> map, List<String> keywords, Extensions container, Configurations configContainer) throws IOException {
        keySet = new HashSet<String>(map.keySet());
        keySet.removeAll(keywords);
        for (String key : keySet) {
            pos = key.indexOf(58);
            postfix = pos == -1 ? null : key.substring(pos + 1);
            v0 = sep = postfix == null ? key.indexOf(124) : postfix.indexOf(124);
            if (pos == -1) {
                type = ExtensionType.ARTIFACTS.name();
                if (sep == -1) {
                    name = key;
                    optional = Boolean.FALSE.toString();
                } else {
                    name = key.substring(0, sep);
                    optional = key.substring(sep + 1);
                }
            } else {
                name = key.substring(0, pos);
                if (sep == -1) {
                    type = postfix;
                    optional = Boolean.FALSE.toString();
                } else {
                    type = postfix.substring(0, sep);
                    optional = postfix.substring(sep + 1);
                }
            }
            if (JSONConstants.APP_KNOWN_PROPERTIES.contains(name)) {
                throw new IOException(this.exceptionPrefix + "Extension is using reserved name : " + name);
            }
            if (JSONConstants.FEATURE_KNOWN_PROPERTIES.contains(name)) {
                throw new IOException(this.exceptionPrefix + "Extension is using reserved name : " + name);
            }
            if (container.getByName(name) != null) {
                throw new IOException(this.exceptionPrefix + "Duplicate extension with name " + name);
            }
            extType = ExtensionType.valueOf((String)type);
            opt = Boolean.valueOf(optional);
            ext = new Extension(extType, name, opt);
            value = map.get(key);
            switch (1.$SwitchMap$org$apache$sling$feature$ExtensionType[extType.ordinal()]) {
                case 1: {
                    list = new ArrayList<Artifact>();
                    this.readArtifacts("Extension " + name, "artifact", list, value, configContainer);
                    for (Artifact a : list) {
                        if (ext.getArtifacts().contains(a)) {
                            throw new IOException(this.exceptionPrefix + "Duplicate artifact in extension " + name + " : " + a.getId().toMvnId());
                        }
                        ext.getArtifacts().add(a);
                    }
                    break;
                }
                case 2: {
                    this.checkType("JSON Extension " + name, value, new Class[]{Map.class, List.class});
                    struct = this.build(value);
                    w = new StringWriter();
                    var21_21 = null;
                    jw = Json.createWriter((Writer)w);
                    jw.write(struct);
                    w.flush();
                    ext.setJSON(w.toString());
                    if (w == null) break;
                    if (var21_21 == null) ** GOTO lbl63
                    try {
                        w.close();
                    }
                    catch (Throwable var22_23) {
                        var21_21.addSuppressed(var22_23);
                    }
                    break;
lbl63:
                    // 1 sources

                    w.close();
                    break;
                    catch (Throwable var22_24) {
                        try {
                            var21_21 = var22_24;
                            throw var22_24;
                        }
                        catch (Throwable var23_26) {
                            if (w != null) {
                                if (var21_21 != null) {
                                    try {
                                        w.close();
                                    }
                                    catch (Throwable var24_27) {
                                        var21_21.addSuppressed(var24_27);
                                    }
                                } else {
                                    w.close();
                                }
                            }
                            throw var23_26;
                        }
                    }
                }
                case 3: {
                    this.checkType("Text Extension " + name, value, new Class[]{String.class, List.class});
                    if (value instanceof String) {
                        ext.setText(value.toString());
                        break;
                    }
                    l = (List)value;
                    sb = new StringBuilder();
                    for (E o : l) {
                        this.checkType("Text Extension " + name + ", value " + o, o, new Class[]{String.class});
                        sb.append(o.toString());
                        sb.append('\n');
                    }
                    ext.setText(sb.toString());
                }
            }
            container.add((Object)ext);
        }
    }

    private JsonStructure build(Object value) {
        if (value instanceof List) {
            List list = (List)value;
            JsonArrayBuilder builder = Json.createArrayBuilder();
            for (Object obj : list) {
                if (obj instanceof String) {
                    builder.add(obj.toString());
                    continue;
                }
                if (obj instanceof Long) {
                    builder.add(((Long)obj).longValue());
                    continue;
                }
                if (obj instanceof Double) {
                    builder.add(((Double)obj).doubleValue());
                    continue;
                }
                if (obj instanceof Boolean) {
                    builder.add(((Boolean)obj).booleanValue());
                    continue;
                }
                if (obj instanceof Map) {
                    builder.add((JsonValue)this.build(obj));
                    continue;
                }
                if (!(obj instanceof List)) continue;
                builder.add((JsonValue)this.build(obj));
            }
            return builder.build();
        }
        if (value instanceof Map) {
            Map map = (Map)value;
            JsonObjectBuilder builder = Json.createObjectBuilder();
            for (Map.Entry entry : map.entrySet()) {
                if (entry.getValue() instanceof String) {
                    builder.add((String)entry.getKey(), entry.getValue().toString());
                    continue;
                }
                if (entry.getValue() instanceof Long) {
                    builder.add((String)entry.getKey(), ((Long)entry.getValue()).longValue());
                    continue;
                }
                if (entry.getValue() instanceof Double) {
                    builder.add((String)entry.getKey(), ((Double)entry.getValue()).doubleValue());
                    continue;
                }
                if (entry.getValue() instanceof Boolean) {
                    builder.add((String)entry.getKey(), ((Boolean)entry.getValue()).booleanValue());
                    continue;
                }
                if (entry.getValue() instanceof Map) {
                    builder.add((String)entry.getKey(), (JsonValue)this.build(entry.getValue()));
                    continue;
                }
                if (!(entry.getValue() instanceof List)) continue;
                builder.add((String)entry.getKey(), (JsonValue)this.build(entry.getValue()));
            }
            return builder.build();
        }
        return null;
    }

    protected void checkType(String key, Object val, Class<?> ... types) throws IOException {
        boolean valid = false;
        for (Class<?> c : types) {
            if (!c.isInstance(val)) continue;
            valid = true;
            break;
        }
        if (!valid) {
            throw new IOException(this.exceptionPrefix + "Key " + key + " is not one of the allowed types " + Arrays.toString(types) + " : " + val.getClass());
        }
    }
}

