/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.io.json;

import java.io.IOException;
import java.io.Writer;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.json.Json;
import javax.json.JsonArrayBuilder;
import javax.json.JsonObjectBuilder;
import javax.json.JsonValue;
import javax.json.JsonWriter;
import javax.json.JsonWriterFactory;
import org.apache.sling.feature.ArtifactId;
import org.apache.sling.feature.Configuration;
import org.apache.sling.feature.Configurations;
import org.apache.sling.feature.Extension;
import org.apache.sling.feature.Feature;
import org.apache.sling.feature.Include;
import org.apache.sling.feature.io.json.JSONWriterBase;
import org.apache.sling.feature.io.json.ManifestUtils;
import org.osgi.resource.Capability;
import org.osgi.resource.Requirement;

public class FeatureJSONWriter
extends JSONWriterBase {
    private FeatureJSONWriter() {
    }

    public static void write(Writer writer, Feature feature) throws IOException {
        FeatureJSONWriter w = new FeatureJSONWriter();
        w.writeFeature(writer, feature);
    }

    private void writeProperty(JsonObjectBuilder ob, String key, String value) {
        if (value != null) {
            ob.add(key, value);
        }
    }

    private void writeFeature(Writer writer, Feature feature) throws IOException {
        JsonObjectBuilder reqObj;
        JsonObjectBuilder attrObj;
        JsonObjectBuilder ob = Json.createObjectBuilder();
        ob.add("id", feature.getId().toMvnId());
        this.writeProperty(ob, "title", feature.getTitle());
        this.writeProperty(ob, "description", feature.getDescription());
        this.writeProperty(ob, "vendor", feature.getVendor());
        this.writeProperty(ob, "license", feature.getLicense());
        this.writeVariables(ob, feature.getVariables());
        if (!feature.getIncludes().isEmpty()) {
            JsonArrayBuilder incArray = Json.createArrayBuilder();
            for (Include inc : feature.getIncludes()) {
                if (inc.getArtifactExtensionRemovals().isEmpty() && inc.getBundleRemovals().isEmpty() && inc.getConfigurationRemovals().isEmpty() && inc.getFrameworkPropertiesRemovals().isEmpty()) {
                    incArray.add(inc.getId().toMvnId());
                    continue;
                }
                JsonObjectBuilder includeObj = Json.createObjectBuilder();
                includeObj.add("id", inc.getId().toMvnId());
                JsonObjectBuilder removalsObj = Json.createObjectBuilder();
                if (!inc.getArtifactExtensionRemovals().isEmpty() || inc.getExtensionRemovals().isEmpty()) {
                    JsonArrayBuilder extRemovals = Json.createArrayBuilder();
                    for (String string : inc.getExtensionRemovals()) {
                        extRemovals.add(string);
                    }
                    for (Map.Entry entry : inc.getArtifactExtensionRemovals().entrySet()) {
                        JsonArrayBuilder ab = Json.createArrayBuilder();
                        for (ArtifactId id : (List)entry.getValue()) {
                            ab.add(id.toMvnId());
                        }
                        extRemovals.add((JsonValue)Json.createObjectBuilder().add((String)entry.getKey(), (JsonValue)ab.build()).build());
                    }
                    removalsObj.add("extensions", (JsonValue)extRemovals.build());
                }
                if (!inc.getConfigurationRemovals().isEmpty()) {
                    JsonArrayBuilder cfgRemovals = Json.createArrayBuilder();
                    for (String string : inc.getConfigurationRemovals()) {
                        cfgRemovals.add(string);
                    }
                    removalsObj.add("configurations", (JsonValue)cfgRemovals.build());
                }
                if (!inc.getBundleRemovals().isEmpty()) {
                    JsonArrayBuilder bundleRemovals = Json.createArrayBuilder();
                    for (ArtifactId artifactId : inc.getBundleRemovals()) {
                        bundleRemovals.add(artifactId.toMvnId());
                    }
                    removalsObj.add("bundles", (JsonValue)bundleRemovals.build());
                }
                if (!inc.getFrameworkPropertiesRemovals().isEmpty()) {
                    JsonArrayBuilder propRemovals = Json.createArrayBuilder();
                    for (String string : inc.getFrameworkPropertiesRemovals()) {
                        propRemovals.add(string);
                    }
                    removalsObj.add("framework-properties", (JsonValue)propRemovals.build());
                }
                includeObj.add("removals", (JsonValue)removalsObj.build());
                incArray.add((JsonValue)includeObj.build());
            }
            ob.add("includes", (JsonValue)incArray.build());
        }
        if (!feature.getRequirements().isEmpty()) {
            JsonArrayBuilder requirements = Json.createArrayBuilder();
            for (Requirement req : feature.getRequirements()) {
                JsonObjectBuilder requirementObj = Json.createObjectBuilder();
                requirementObj.add("namespace", req.getNamespace());
                if (!req.getAttributes().isEmpty()) {
                    attrObj = Json.createObjectBuilder();
                    req.getAttributes().forEach((key, value) -> ManifestUtils.marshalAttribute(key, value, (arg_0, arg_1) -> ((JsonObjectBuilder)attrObj).add(arg_0, arg_1)));
                    requirementObj.add("attributes", (JsonValue)attrObj.build());
                }
                if (!req.getDirectives().isEmpty()) {
                    reqObj = Json.createObjectBuilder();
                    req.getDirectives().forEach((key, value) -> ManifestUtils.marshalDirective(key, value, (arg_0, arg_1) -> ((JsonObjectBuilder)reqObj).add(arg_0, arg_1)));
                    requirementObj.add("directives", (JsonValue)reqObj.build());
                }
                requirements.add((JsonValue)requirementObj.build());
            }
            ob.add("requirements", (JsonValue)requirements.build());
        }
        if (!feature.getCapabilities().isEmpty()) {
            JsonArrayBuilder capabilities = Json.createArrayBuilder();
            for (Capability cap : feature.getCapabilities()) {
                JsonObjectBuilder capabilityObj = Json.createObjectBuilder();
                capabilityObj.add("namespace", cap.getNamespace());
                if (!cap.getAttributes().isEmpty()) {
                    attrObj = Json.createObjectBuilder();
                    cap.getAttributes().forEach((key, value) -> ManifestUtils.marshalAttribute(key, value, (arg_0, arg_1) -> ((JsonObjectBuilder)attrObj).add(arg_0, arg_1)));
                    capabilityObj.add("attributes", (JsonValue)attrObj.build());
                }
                if (!cap.getDirectives().isEmpty()) {
                    reqObj = Json.createObjectBuilder();
                    cap.getDirectives().forEach((key, value) -> ManifestUtils.marshalDirective(key, value, (arg_0, arg_1) -> ((JsonObjectBuilder)reqObj).add(arg_0, arg_1)));
                    capabilityObj.add("directives", (JsonValue)reqObj.build());
                }
                capabilities.add((JsonValue)capabilityObj.build());
            }
            ob.add("capabilities", (JsonValue)capabilities.build());
        }
        this.writeBundles(ob, feature.getBundles(), feature.getConfigurations());
        Configurations cfgs = new Configurations();
        for (Configuration cfg : feature.getConfigurations()) {
            String artifactProp = (String)cfg.getProperties().get("service.bundleLocation");
            if (artifactProp != null) continue;
            cfgs.add((Object)cfg);
        }
        this.writeConfigurations(ob, cfgs);
        this.writeFrameworkProperties(ob, feature.getFrameworkProperties());
        this.writeExtensions(ob, (List<Extension>)feature.getExtensions(), feature.getConfigurations());
        JsonWriterFactory writerFactory = Json.createWriterFactory(Collections.singletonMap("javax.json.stream.JsonGenerator.prettyPrinting", true));
        JsonWriter jw = writerFactory.createWriter(writer);
        jw.writeObject(ob.build());
        jw.close();
    }
}

