/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.io.json;

import java.io.IOException;
import java.io.Writer;
import java.util.Collections;
import java.util.List;
import javax.json.Json;
import javax.json.JsonArrayBuilder;
import javax.json.JsonObjectBuilder;
import javax.json.JsonValue;
import javax.json.JsonWriter;
import javax.json.JsonWriterFactory;
import org.apache.sling.feature.Application;
import org.apache.sling.feature.ArtifactId;
import org.apache.sling.feature.Configuration;
import org.apache.sling.feature.Configurations;
import org.apache.sling.feature.Extension;
import org.apache.sling.feature.io.json.JSONWriterBase;

public class ApplicationJSONWriter
extends JSONWriterBase {
    public static void write(Writer writer, Application app) throws IOException {
        ApplicationJSONWriter w = new ApplicationJSONWriter();
        w.writeApp(writer, app);
    }

    private void writeApp(Writer writer, Application app) throws IOException {
        JsonObjectBuilder ob = Json.createObjectBuilder();
        if (app.getFramework() != null) {
            ob.add("frameworkId", app.getFramework().toMvnId());
        }
        if (!app.getFeatureIds().isEmpty()) {
            JsonArrayBuilder featuresArr = Json.createArrayBuilder();
            for (ArtifactId id : app.getFeatureIds()) {
                featuresArr.add(id.toMvnId());
            }
            ob.add("features", (JsonValue)featuresArr.build());
        }
        this.writeBundles(ob, app.getBundles(), app.getConfigurations());
        Configurations cfgs = new Configurations();
        for (Configuration cfg : app.getConfigurations()) {
            String artifactProp = (String)cfg.getProperties().get("service.bundleLocation");
            if (artifactProp != null) continue;
            cfgs.add((Object)cfg);
        }
        this.writeConfigurations(ob, cfgs);
        this.writeFrameworkProperties(ob, app.getFrameworkProperties());
        this.writeExtensions(ob, (List<Extension>)app.getExtensions(), app.getConfigurations());
        JsonWriterFactory writerFactory = Json.createWriterFactory(Collections.singletonMap("javax.json.stream.JsonGenerator.prettyPrinting", true));
        JsonWriter jw = writerFactory.createWriter(writer);
        jw.writeObject(ob.build());
        jw.close();
    }
}

