/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.io.json;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Map;
import javax.json.Json;
import javax.json.JsonObject;
import javax.json.JsonValue;
import org.apache.felix.configurator.impl.json.JSONUtil;
import org.apache.sling.feature.Application;
import org.apache.sling.feature.ArtifactId;
import org.apache.sling.feature.io.json.JSONConstants;
import org.apache.sling.feature.io.json.JSONReaderBase;

public class ApplicationJSONReader
extends JSONReaderBase {
    private final Application app = new Application();

    public static Application read(Reader reader) throws IOException {
        try {
            ApplicationJSONReader mr = new ApplicationJSONReader();
            mr.readApplication(reader);
            return mr.app;
        }
        catch (IllegalArgumentException | IllegalStateException e) {
            throw new IOException(e);
        }
    }

    private ApplicationJSONReader() {
        super(null);
    }

    private void readApplication(Reader reader) throws IOException {
        JsonObject json = Json.createReader((Reader)new StringReader(this.minify(reader))).readObject();
        Map map = (Map)JSONUtil.getValue((JsonValue)json);
        String frameworkId = this.getProperty(map, "frameworkId");
        if (frameworkId != null) {
            this.app.setFramework(ArtifactId.parse((String)frameworkId));
        }
        this.readBundles(map, this.app.getBundles(), this.app.getConfigurations());
        this.readFrameworkProperties(map, this.app.getFrameworkProperties());
        this.readConfigurations(map, this.app.getConfigurations());
        this.readExtensions(map, JSONConstants.APP_KNOWN_PROPERTIES, this.app.getExtensions(), this.app.getConfigurations());
    }
}

