/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.io;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.sling.feature.ArtifactId;
import org.apache.sling.feature.Feature;
import org.apache.sling.feature.io.ArtifactHandler;
import org.apache.sling.feature.io.ArtifactManager;
import org.apache.sling.feature.io.json.FeatureJSONReader;

public class IOUtils {
    public static final String EXTENSION_REF_FILE = ".ref";
    public static final String EXTENSION_FEATURE_FILE = ".json";
    public static final String DEFAULT_DIRECTORY = "features";
    public static final String DEFAULT_FEATURE_FILE = "feature.json";
    static final Comparator<String> FEATURE_PATH_COMP = new Comparator<String>(){

        @Override
        public int compare(String o1, String o2) {
            String path2;
            String key1 = o1.replace(File.separatorChar, '/');
            String key2 = o2.replace(File.separatorChar, '/');
            int lastSlash1 = key1.lastIndexOf(47);
            int lastSlash2 = key2.lastIndexOf(47);
            if (lastSlash1 == -1 || lastSlash2 == -1) {
                return o1.compareTo(o2);
            }
            String path1 = key1.substring(0, lastSlash1 + 1);
            if (path1.equals(path2 = key2.substring(0, lastSlash2 + 1))) {
                return o1.compareTo(o2);
            }
            if (path1.startsWith(path2)) {
                return 1;
            }
            if (path2.startsWith(path1)) {
                return -1;
            }
            return o1.compareTo(o2);
        }
    };

    public static List<String> parseFeatureRefFile(File file) throws IOException {
        ArrayList<String> result = new ArrayList<String>();
        List<String> lines = Files.readAllLines(file.toPath());
        for (String line : lines) {
            if ((line = line.trim()).isEmpty() || line.startsWith("#")) continue;
            if (line.indexOf(58) == -1) {
                result.add(new File(line).getAbsolutePath());
                continue;
            }
            result.add(line);
        }
        return result;
    }

    public static List<String> getFeatureFiles(File homeDirectory, String ... files) throws IOException {
        String[] featureFiles = files;
        if (featureFiles == null || featureFiles.length == 0) {
            File[] candidates = new File[]{new File(homeDirectory, DEFAULT_DIRECTORY), new File(homeDirectory, DEFAULT_FEATURE_FILE), new File(DEFAULT_DIRECTORY), new File(DEFAULT_FEATURE_FILE)};
            File f = null;
            File[] fileArray = candidates;
            int n = fileArray.length;
            for (int i = 0; i < n; ++i) {
                File c = fileArray[i];
                if (!c.exists()) continue;
                f = c;
                break;
            }
            if (f == null) {
                f = candidates[0];
            }
            featureFiles = new String[]{f.getAbsolutePath()};
        }
        ArrayList<String> paths = new ArrayList<String>();
        for (String name : featureFiles) {
            if (name.indexOf(58) > 1) {
                paths.add(name);
                continue;
            }
            File f = null;
            File test = new File(name);
            if (test.isAbsolute()) {
                f = test;
            } else {
                File[] candidates;
                for (File c : candidates = new File[]{new File(homeDirectory, name), new File(homeDirectory, DEFAULT_DIRECTORY + File.separatorChar + name), new File(name), new File(DEFAULT_DIRECTORY + File.separatorChar + name)}) {
                    if (!c.exists() || !c.isFile()) continue;
                    f = c;
                    break;
                }
            }
            if (f != null && f.exists()) {
                if (f.isFile()) {
                    IOUtils.processFile(paths, f);
                    continue;
                }
                IOUtils.processDir(paths, f);
                continue;
            }
            paths.add(new File(name).getAbsolutePath());
        }
        Collections.sort(paths, FEATURE_PATH_COMP);
        return paths;
    }

    public static Feature getFeature(String url, ArtifactManager artifactManager, FeatureJSONReader.SubstituteVariables substituteVariables) throws IOException {
        ArtifactHandler featureArtifact = artifactManager.getArtifactHandler(url);
        try (FileReader r = new FileReader(featureArtifact.getFile());){
            Feature f;
            Feature feature = f = FeatureJSONReader.read(r, featureArtifact.getUrl(), substituteVariables);
            return feature;
        }
    }

    public static ArtifactId getFelixFrameworkId(String version) {
        return new ArtifactId("org.apache.felix", "org.apache.felix.framework", version != null ? version : "5.6.10", null, null);
    }

    private static void processDir(List<String> paths, File dir) throws IOException {
        for (File f : dir.listFiles()) {
            if (!f.isFile() || f.getName().startsWith(".") || !f.getName().endsWith(EXTENSION_REF_FILE) && !f.getName().endsWith(EXTENSION_FEATURE_FILE)) continue;
            IOUtils.processFile(paths, f);
        }
    }

    private static void processFile(List<String> paths, File f) throws IOException {
        if (f.getName().endsWith(EXTENSION_REF_FILE)) {
            paths.addAll(IOUtils.parseFeatureRefFile(f));
        } else {
            paths.add(f.getAbsolutePath());
        }
    }
}

