/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.launcher.impl;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.ServiceLoader;
import org.apache.sling.feature.ArtifactId;
import org.apache.sling.feature.ExecutionEnvironmentExtension;
import org.apache.sling.feature.Feature;
import org.apache.sling.feature.io.artifacts.ArtifactHandler;
import org.apache.sling.feature.io.artifacts.ArtifactManager;
import org.apache.sling.feature.io.artifacts.ArtifactManagerConfig;
import org.apache.sling.feature.io.json.FeatureJSONWriter;
import org.apache.sling.feature.launcher.impl.FeatureProcessor;
import org.apache.sling.feature.launcher.impl.Installation;
import org.apache.sling.feature.launcher.impl.LauncherConfig;
import org.apache.sling.feature.launcher.impl.Main;
import org.apache.sling.feature.launcher.spi.Launcher;
import org.apache.sling.feature.launcher.spi.LauncherPrepareContext;
import org.slf4j.Logger;

public class Bootstrap {
    public static final String FELIX_FRAMEWORK_VERSION = "7.0.3";
    private final LauncherConfig config;
    private final Logger logger;
    private static final String STORAGE_PROPERTY = "org.osgi.framework.storage";
    private static final String START_LEVEL_PROP = "org.osgi.framework.startlevel.beginning";

    public Bootstrap(LauncherConfig config, Logger logger) {
        this.config = config;
        this.logger = logger;
    }

    private ArtifactId getFelixFrameworkId(String version) {
        return new ArtifactId("org.apache.felix", "org.apache.felix.framework", version != null ? version : FELIX_FRAMEWORK_VERSION, null, null);
    }

    private void prepare() {
        this.config.getVariables().put("sling.home", this.config.getHomeDirectory().getAbsolutePath());
        if (this.config.getVariables().get("repository.home") == null) {
            this.config.getVariables().put("repository.home", this.config.getHomeDirectory().getAbsolutePath() + File.separatorChar + "repository");
        }
        this.config.getVariables().put("sling.launchpad", this.config.getHomeDirectory().getAbsolutePath() + "/launchpad");
        Installation installation = this.config.getInstallation();
        installation.setLogger(this.logger);
        installation.getFrameworkProperties().put("sling.home", this.config.getHomeDirectory().getAbsolutePath());
        installation.getFrameworkProperties().put("sling.launchpad", this.config.getHomeDirectory().getAbsolutePath() + "/launchpad");
        if (!installation.getFrameworkProperties().containsKey("repository.home")) {
            installation.getFrameworkProperties().put("repository.home", this.config.getHomeDirectory().getAbsolutePath() + File.separatorChar + "repository");
        }
        installation.getFrameworkProperties().put("sling.properties", "conf/sling.properties");
        installation.getFrameworkProperties().put("sling.feature", Bootstrap.getApplicationFeatureFile(this.config).toURI().toString());
    }

    public void run() {
        this.logger.info("");
        this.logger.info("Apache Sling Application Launcher");
        this.logger.info("---------------------------------");
        this.logger.info("Initializing...");
        this.prepare();
        Iterator<Launcher> iterator = ServiceLoader.load(Launcher.class).iterator();
        if (!iterator.hasNext()) {
            this.logger.error("Unable to find launcher service.");
            System.exit(1);
        }
        Launcher launcher = iterator.next();
        try (final ArtifactManager artifactManager = ArtifactManager.getArtifactManager((ArtifactManagerConfig)this.config);){
            this.logger.info("Artifact Repositories: {}", (Object)Arrays.toString(this.config.getRepositoryUrls()));
            this.logger.info("Assembling final feature model...");
            try {
                boolean restart = this.config.getFeatureFiles().isEmpty();
                HashMap<ArtifactId, Feature> loadedFeatures = new HashMap<ArtifactId, Feature>();
                Feature app = this.assemble(artifactManager, loadedFeatures);
                this.logger.info("");
                this.logger.info("Assembling launcher...");
                LauncherPrepareContext ctx = new LauncherPrepareContext(){

                    @Override
                    public Logger getLogger() {
                        return Bootstrap.this.logger;
                    }

                    @Override
                    public URL getArtifactFile(ArtifactId artifact) throws IOException {
                        ArtifactHandler handler = artifactManager.getArtifactHandler(":" + artifact.toMvnPath());
                        return handler.getLocalURL();
                    }

                    @Override
                    public void addAppJar(URL jar) {
                        Bootstrap.this.config.getInstallation().addAppJar(jar);
                    }
                };
                launcher.prepare(ctx, this.getFrameworkArtifactId(app), app);
                FeatureProcessor.prepareLauncher(ctx, this.config, app, loadedFeatures);
                this.logger.info("Using {} local artifacts, {} cached artifacts, and {} downloaded artifacts", new Object[]{this.config.getLocalArtifacts(), this.config.getCachedArtifacts(), this.config.getDownloadedArtifacts()});
                if (restart) {
                    this.config.getInstallation().getInstallableArtifacts().clear();
                    this.config.getInstallation().getConfigurations().clear();
                    this.config.getInstallation().getBundleMap().clear();
                }
            }
            catch (Exception iae) {
                this.logger.error("Error while assembling launcher: {}", (Object)iae.getMessage(), (Object)iae);
                System.exit(1);
            }
        }
        catch (IOException ex) {
            this.logger.error("Unable to setup artifact manager: {}", (Object)ex.getMessage(), (Object)ex);
            System.exit(1);
        }
        try {
            this.run(launcher);
        }
        catch (Exception iae) {
            this.logger.error("Error while running launcher: {}", (Object)iae.getMessage(), (Object)iae);
            System.exit(1);
        }
    }

    private ArtifactId getFrameworkArtifactId(Feature app) {
        if (this.config.getFrameworkArtifact() != null) {
            return ArtifactId.parse((String)this.config.getFrameworkArtifact());
        }
        if (this.config.getFrameworkVersion() != null) {
            return this.getFelixFrameworkId(this.config.getFrameworkVersion());
        }
        ExecutionEnvironmentExtension env = ExecutionEnvironmentExtension.getExecutionEnvironmentExtension((Feature)app);
        if (env != null && env.getFramework() != null) {
            return env.getFramework().getId();
        }
        return this.getFelixFrameworkId(null);
    }

    private Feature assemble(ArtifactManager artifactManager, Map<ArtifactId, Feature> loadedFeatures) throws IOException {
        if (this.config.getFeatureFiles().isEmpty()) {
            File application = Bootstrap.getApplicationFeatureFile(this.config);
            if (!application.isFile()) {
                Main.printHelp();
                throw new IllegalStateException("No feature(s) to launch found and none where specified");
            }
            this.config.addFeatureFiles(application.toURI().toURL().toString());
            return FeatureProcessor.createApplication(this.logger, this.config, artifactManager, loadedFeatures);
        }
        Feature app = FeatureProcessor.createApplication(this.logger, this.config, artifactManager, loadedFeatures);
        File file = Bootstrap.getApplicationFeatureFile(this.config);
        Files.createDirectories(file.getParentFile().toPath(), new FileAttribute[0]);
        try (FileWriter writer = new FileWriter(file);){
            FeatureJSONWriter.write((Writer)writer, (Feature)app);
        }
        catch (IOException ioe) {
            this.logger.error("Error while writing application file: {}", (Object)ioe.getMessage(), (Object)ioe);
            System.exit(1);
        }
        return app;
    }

    private static File getApplicationFeatureFile(LauncherConfig launcherConfig) {
        return new File(launcherConfig.getHomeDirectory(), "resources" + File.separatorChar + "provisioning" + File.separatorChar + "application.json");
    }

    private void run(Launcher launcher) throws Exception {
        this.logger.info("");
        this.logger.info("Starting launcher...");
        this.logger.info("Launcher Home: {}", (Object)this.config.getHomeDirectory().getAbsolutePath());
        this.logger.info("Cache Directory: {}", (Object)this.config.getCacheDirectory().getAbsolutePath());
        this.logger.info("");
        Installation installation = this.config.getInstallation();
        installation.getFrameworkProperties().put("sling.home", this.config.getHomeDirectory().getAbsolutePath());
        installation.getFrameworkProperties().put("sling.launchpad", this.config.getHomeDirectory().getAbsolutePath() + "/launchpad");
        if (!installation.getFrameworkProperties().containsKey("repository.home")) {
            installation.getFrameworkProperties().put("repository.home", this.config.getHomeDirectory().getAbsolutePath() + File.separatorChar + "repository");
        }
        installation.getFrameworkProperties().put("sling.properties", "conf/sling.properties");
        installation.getFrameworkProperties().put("sling.feature", Bootstrap.getApplicationFeatureFile(this.config).toURI().toString());
        installation.getFrameworkProperties().putIfAbsent(STORAGE_PROPERTY, this.config.getHomeDirectory().getAbsolutePath() + File.separatorChar + "framework");
        installation.getFrameworkProperties().putIfAbsent(START_LEVEL_PROP, "30");
        while (launcher.run(installation, this.createClassLoader(installation, launcher)) == 1024) {
            this.logger.info("Framework restart due to extension refresh");
        }
    }

    public ClassLoader createClassLoader(Installation installation, Launcher launcher) throws Exception {
        ArrayList<URL> list = new ArrayList<URL>();
        list.addAll(installation.getAppJars());
        list.add(Bootstrap.class.getProtectionDomain().getCodeSource().getLocation());
        Launcher.LauncherClassLoader cl = launcher.createClassLoader();
        URL[] urls = list.toArray(new URL[list.size()]);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("App classpath: ");
            for (int i = 0; i < urls.length; ++i) {
                this.logger.debug(" - {}", (Object)urls[i]);
            }
        }
        for (URL u : urls) {
            cl.addURL(u);
        }
        Thread.currentThread().setContextClassLoader(cl);
        return cl;
    }
}

