/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.extension.unpack.impl.installer;

import java.io.IOException;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.sling.feature.ArtifactId;
import org.apache.sling.feature.extension.unpack.Unpack;
import org.apache.sling.feature.extension.unpack.impl.installer.InstallUnpackArchiveTask;
import org.apache.sling.installer.api.tasks.InstallTask;
import org.apache.sling.installer.api.tasks.InstallTaskFactory;
import org.apache.sling.installer.api.tasks.RegisteredResource;
import org.apache.sling.installer.api.tasks.ResourceState;
import org.apache.sling.installer.api.tasks.ResourceTransformer;
import org.apache.sling.installer.api.tasks.TaskResource;
import org.apache.sling.installer.api.tasks.TaskResourceGroup;
import org.apache.sling.installer.api.tasks.TransformationResult;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={InstallTaskFactory.class, ResourceTransformer.class})
public class UnpackArchiveInstallerPlugin
implements InstallTaskFactory,
ResourceTransformer {
    public static final String TYPE_UNPACK_ARCHIVE = "unpackarchive";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    final Unpack unpack;

    @Activate
    public UnpackArchiveInstallerPlugin(BundleContext bc) {
        this(Unpack.fromMapping(bc.getProperty("org.apache.sling.feature.unpack.extensions")));
    }

    UnpackArchiveInstallerPlugin(Unpack unpack) {
        this.unpack = unpack;
    }

    public TransformationResult[] transform(RegisteredResource resource) {
        if (!"file".equals(resource.getType())) {
            return null;
        }
        Hashtable dict = resource.getDictionary();
        if (dict == null) {
            dict = new Hashtable();
        }
        Map<String, Object> context = Collections.list(((Dictionary)dict).keys()).stream().collect(Collectors.toMap(Function.identity(), dict::get));
        try {
            if (!this.unpack.handles(resource.getInputStream(), context)) {
                return null;
            }
        }
        catch (IOException e) {
            this.logger.warn("Unable to read stream from {}", (Object)resource.getURL(), (Object)e);
            return null;
        }
        try {
            ArtifactId aid = (ArtifactId)((Dictionary)dict).get("artifact.id");
            if (aid == null) {
                int idx;
                String u = resource.getURL();
                String name = u.substring((idx = u.lastIndexOf(47)) + 1);
                int idx2 = name.lastIndexOf(46);
                if (idx2 >= 0) {
                    name = name.substring(0, idx2);
                }
                aid = new ArtifactId("unpack.packages", name, resource.getDigest(), null, null);
            }
            TransformationResult tr = new TransformationResult();
            tr.setResourceType(TYPE_UNPACK_ARCHIVE);
            tr.setId(aid.getGroupId() + ":" + aid.getArtifactId());
            tr.setInputStream(resource.getInputStream());
            tr.setAttributes(context);
            tr.getAttributes().put("context", context);
            return new TransformationResult[]{tr};
        }
        catch (IOException e) {
            this.logger.warn("Problem processing {}", (Object)resource.getURL(), (Object)e);
            return null;
        }
    }

    public InstallTask createTask(TaskResourceGroup group) {
        TaskResource tr = group.getActiveResource();
        if (!TYPE_UNPACK_ARCHIVE.equals(tr.getType())) {
            return null;
        }
        if (tr.getState() != ResourceState.INSTALL) {
            return null;
        }
        return new InstallUnpackArchiveTask(group, this.unpack, this.logger);
    }
}

