/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.jackrabbit.vault.packaging.registry.impl;

import java.io.IOException;
import java.nio.file.Path;
import java.util.Calendar;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import shaded.org.apache.jackrabbit.vault.fs.api.WorkspaceFilter;
import shaded.org.apache.jackrabbit.vault.packaging.Dependency;
import shaded.org.apache.jackrabbit.vault.packaging.PackageId;
import shaded.org.apache.jackrabbit.vault.packaging.PackageProperties;
import shaded.org.apache.jackrabbit.vault.packaging.VaultPackage;
import shaded.org.apache.jackrabbit.vault.packaging.registry.RegisteredPackage;
import shaded.org.apache.jackrabbit.vault.packaging.registry.impl.FSInstallState;
import shaded.org.apache.jackrabbit.vault.packaging.registry.impl.FSPackageRegistry;
import shaded.org.apache.jackrabbit.vault.packaging.registry.impl.FsPackageProperties;

public class FSRegisteredPackage
implements RegisteredPackage {
    private static final Logger log = LoggerFactory.getLogger(FSPackageRegistry.class);
    private FSPackageRegistry registry;
    private VaultPackage vltPkg = null;
    private PackageId id;
    private Path filepath;
    private PackageProperties packageProperties;
    private Dependency[] dependencies;
    private WorkspaceFilter filter;
    private long size;

    public FSRegisteredPackage(FSPackageRegistry registry, FSInstallState installState) throws IOException {
        this.id = installState.getPackageId();
        this.filepath = installState.getFilePath();
        this.dependencies = installState.getDependencies().toArray(new Dependency[installState.getDependencies().size()]);
        this.filter = installState.getFilter();
        this.packageProperties = new FsPackageProperties(installState);
        this.registry = registry;
        this.size = installState.getSize();
    }

    @Override
    @Nonnull
    public PackageId getId() {
        return this.id;
    }

    @Override
    @Nonnull
    public VaultPackage getPackage() throws IOException {
        if (this.vltPkg == null) {
            this.vltPkg = this.registry.open(this.filepath.toFile());
        }
        return this.vltPkg;
    }

    @Override
    public boolean isInstalled() {
        try {
            return this.registry.isInstalled(this.getId());
        }
        catch (IOException e) {
            log.error("Packagestate couldn't be read for package {}", (Object)this.getId().toString(), (Object)e);
            return false;
        }
    }

    @Override
    public long getSize() {
        return this.size;
    }

    @Override
    @CheckForNull
    public Calendar getInstallationTime() {
        Calendar cal = Calendar.getInstance();
        try {
            Long installTime = this.registry.getInstallState(this.getId()).getInstallationTime();
            if (installTime == null) {
                cal = null;
            } else {
                cal.setTimeInMillis(installTime);
            }
        }
        catch (IOException e) {
            log.error("Could not read package state for package {}.", (Object)this.getId(), (Object)e);
            cal = null;
        }
        return cal;
    }

    @Override
    public void close() {
        if (this.vltPkg != null) {
            this.vltPkg.close();
            this.vltPkg = null;
        }
    }

    @Override
    public int compareTo(RegisteredPackage o) {
        return this.getId().compareTo(o.getId());
    }

    @Override
    public Dependency[] getDependencies() {
        return this.dependencies;
    }

    @Override
    public WorkspaceFilter getWorkspaceFilter() {
        return this.filter;
    }

    @Override
    public PackageProperties getPackageProperties() throws IOException {
        return this.packageProperties;
    }
}

