/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.jackrabbit.vault.packaging.impl;

import java.util.Iterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import shaded.org.apache.jackrabbit.api.JackrabbitSession;
import shaded.org.apache.jackrabbit.api.security.user.Authorizable;
import shaded.org.apache.jackrabbit.api.security.user.Group;

public class AdminPermissionChecker {
    private static final Logger log = LoggerFactory.getLogger(AdminPermissionChecker.class);
    private static final String ADMIN_USER = "admin";
    private static final String SYSTEM_USER = "system";
    private static final String ADMINISTRATORS_GROUP = "administrators";

    public static boolean hasAdministrativePermissions(Session session) throws RepositoryException {
        String userId = session.getUserID();
        if (ADMIN_USER.equals(userId) || SYSTEM_USER.equals(userId)) {
            return true;
        }
        if (!(session instanceof JackrabbitSession)) {
            log.warn("could not evaluate group permissions but just user name");
            return false;
        }
        JackrabbitSession jackrabbitSession = (JackrabbitSession)session;
        Authorizable authorizable = jackrabbitSession.getUserManager().getAuthorizable(userId);
        if (authorizable == null) {
            return false;
        }
        Iterator groupIterator = authorizable.memberOf();
        while (groupIterator.hasNext()) {
            if (!ADMINISTRATORS_GROUP.equals(((Group)groupIterator.next()).getID())) continue;
            return true;
        }
        return false;
    }
}

