/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.jackrabbit.vault.fs.impl.io;

import java.security.Principal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.ValueFactory;
import javax.jcr.security.AccessControlEntry;
import javax.jcr.security.AccessControlManager;
import javax.jcr.security.AccessControlPolicy;
import javax.jcr.security.AccessControlPolicyIterator;
import javax.jcr.security.Privilege;
import org.slf4j.Logger;
import org.xml.sax.SAXException;
import shaded.org.apache.jackrabbit.api.JackrabbitSession;
import shaded.org.apache.jackrabbit.api.security.JackrabbitAccessControlList;
import shaded.org.apache.jackrabbit.api.security.authorization.PrincipalSetPolicy;
import shaded.org.apache.jackrabbit.api.security.principal.PrincipalManager;
import shaded.org.apache.jackrabbit.vault.fs.impl.io.DocViewAdapter;
import shaded.org.apache.jackrabbit.vault.fs.impl.io.DocViewSAXImporter;
import shaded.org.apache.jackrabbit.vault.fs.io.AccessControlHandling;
import shaded.org.apache.jackrabbit.vault.util.DocViewNode;
import shaded.org.apache.jackrabbit.vault.util.DocViewProperty;

public class JackrabbitACLImporter
implements DocViewAdapter {
    private static final Logger log = DocViewSAXImporter.log;
    private final JackrabbitSession session;
    private final AccessControlHandling aclHandling;
    private final AccessControlManager acMgr;
    private final PrincipalManager pMgr;
    private final String accessControlledPath;
    private ImportedPolicy importPolicy;
    private final Stack<State> states = new Stack();

    public JackrabbitACLImporter(Node accessControlledNode, AccessControlHandling aclHandling) throws RepositoryException {
        this(accessControlledNode.getSession(), accessControlledNode.getPath(), aclHandling);
    }

    public JackrabbitACLImporter(Session session, AccessControlHandling aclHandling) throws RepositoryException {
        this(session, null, aclHandling);
    }

    private JackrabbitACLImporter(Session session, String path, AccessControlHandling aclHandling) throws RepositoryException {
        if (aclHandling == AccessControlHandling.CLEAR || aclHandling == AccessControlHandling.IGNORE) {
            throw new RepositoryException("Error while reading access control content: unsupported AccessControlHandling: " + (Object)((Object)aclHandling));
        }
        this.accessControlledPath = path;
        this.session = (JackrabbitSession)session;
        this.acMgr = this.session.getAccessControlManager();
        this.pMgr = this.session.getPrincipalManager();
        this.aclHandling = aclHandling;
        this.states.push(State.INITIAL);
    }

    @Override
    public void startNode(DocViewNode node) throws SAXException {
        State state = this.states.peek();
        switch (state) {
            case INITIAL: {
                if ("rep:ACL".equals(node.primary)) {
                    this.importPolicy = new ImportedAcList();
                    state = State.ACL;
                    break;
                }
                if ("rep:CugPolicy".equals(node.primary)) {
                    this.importPolicy = new ImportedPrincipalSet(node);
                    state = State.PRINCIPAL_SET_POLICY;
                    break;
                }
                log.error("Error while reading access control content: Expected rep:ACL or rep:CugPolicy but was: {}", (Object)node.primary);
                state = State.ERROR;
                break;
            }
            case ACL: 
            case ACE: 
            case RESTRICTION: {
                state = this.importPolicy.append(state, node);
                break;
            }
            case PRINCIPAL_SET_POLICY: {
                state = this.importPolicy.append(state, node);
                break;
            }
        }
        this.states.push(state);
    }

    @Override
    public void endNode() throws SAXException {
        State state = this.states.pop();
        this.importPolicy.endNode(state);
    }

    @Override
    public List<String> close() throws SAXException {
        if (this.states.peek() != State.INITIAL) {
            log.error("Unexpected end state: {}", (Object)this.states.peek());
        }
        ArrayList<String> paths = new ArrayList<String>();
        try {
            this.importPolicy.apply(paths);
        }
        catch (RepositoryException e) {
            log.error("Error while applying access control content.", (Throwable)e);
        }
        return paths;
    }

    private void addPathIfExists(List<String> paths, String path) throws RepositoryException {
        if (this.session.nodeExists(path)) {
            paths.add(path);
        }
    }

    private static class ACE {
        private final boolean allow;
        private final String principalName;
        private final String[] privileges;
        private final Map<String, DocViewProperty> restrictions = new HashMap<String, DocViewProperty>();

        private ACE(DocViewNode node) {
            if ("rep:GrantACE".equals(node.primary)) {
                this.allow = true;
            } else if ("rep:DenyACE".equals(node.primary)) {
                this.allow = false;
            } else {
                throw new IllegalArgumentException("Unexpected node ACE type: " + node.primary);
            }
            this.principalName = node.getValue("rep:principalName");
            this.privileges = node.getValues("rep:privileges");
            this.addRestrictions(node);
        }

        public void addRestrictions(DocViewNode node) {
            this.restrictions.putAll(node.props);
        }
    }

    private final class ImportedPrincipalSet
    extends ImportedPolicy<PrincipalSetPolicy> {
        private final String[] principalNames;

        private ImportedPrincipalSet(DocViewNode node) {
            this.principalNames = node.getValues("rep:principalNames");
        }

        @Override
        State append(State state, DocViewNode childNode) {
            log.error("Error while reading access control content: Unexpected node: {} for state {}", (Object)childNode.primary, (Object)state);
            return State.ERROR;
        }

        @Override
        void endNode(State state) {
        }

        @Override
        void apply(List<String> paths) throws RepositoryException {
            PrincipalSetPolicy psPolicy = this.getPolicy(PrincipalSetPolicy.class);
            if (psPolicy != null) {
                Set existingPrincipals = psPolicy.getPrincipals();
                if (JackrabbitACLImporter.this.aclHandling == AccessControlHandling.OVERWRITE) {
                    psPolicy.removePrincipals(existingPrincipals.toArray(new Principal[existingPrincipals.size()]));
                }
            } else {
                psPolicy = this.getApplicablePolicy(PrincipalSetPolicy.class);
            }
            Principal[] principals = new Principal[this.principalNames.length];
            for (int i = 0; i < principals.length; ++i) {
                principals[i] = this.getPrincipal(this.principalNames[i]);
            }
            psPolicy.addPrincipals(principals);
            JackrabbitACLImporter.this.acMgr.setPolicy(JackrabbitACLImporter.this.accessControlledPath, (AccessControlPolicy)psPolicy);
            if ("/".equals(JackrabbitACLImporter.this.accessControlledPath)) {
                JackrabbitACLImporter.this.addPathIfExists(paths, "/rep:cugPolicy");
            } else {
                JackrabbitACLImporter.this.addPathIfExists(paths, JackrabbitACLImporter.this.accessControlledPath + "/rep:cugPolicy");
            }
        }
    }

    private final class ImportedAcList
    extends ImportedPolicy<JackrabbitAccessControlList> {
        private List<ACE> aceList;
        private ACE currentACE;

        private ImportedAcList() {
            this.aceList = new ArrayList<ACE>();
        }

        @Override
        State append(State state, DocViewNode childNode) {
            if (state == State.ACL) {
                try {
                    this.currentACE = new ACE(childNode);
                    this.aceList.add(this.currentACE);
                    return State.ACE;
                }
                catch (IllegalArgumentException e) {
                    log.error("Error while reading access control content: {}", (Throwable)e);
                    return State.ERROR;
                }
            }
            if (state == State.ACE) {
                this.currentACE.addRestrictions(childNode);
                return State.RESTRICTION;
            }
            log.error("Error while reading access control content: Unexpected node: {} for state {}", (Object)childNode.primary, (Object)state);
            return State.ERROR;
        }

        @Override
        void endNode(State state) {
            if (state == State.ACE) {
                this.currentACE = null;
            }
        }

        @Override
        void apply(List<String> paths) throws RepositoryException {
            ValueFactory valueFactory = JackrabbitACLImporter.this.session.getValueFactory();
            JackrabbitAccessControlList acl = this.getPolicy(JackrabbitAccessControlList.class);
            HashSet<String> existingPrincipals = new HashSet<String>();
            if (acl != null) {
                for (AccessControlEntry ace : acl.getAccessControlEntries()) {
                    existingPrincipals.add(ace.getPrincipal().getName());
                }
                if (JackrabbitACLImporter.this.aclHandling == AccessControlHandling.OVERWRITE) {
                    JackrabbitACLImporter.this.acMgr.removePolicy(JackrabbitACLImporter.this.accessControlledPath, (AccessControlPolicy)acl);
                    acl = null;
                }
            }
            if (acl == null) {
                acl = this.getApplicablePolicy(JackrabbitAccessControlList.class);
            }
            if (JackrabbitACLImporter.this.aclHandling == AccessControlHandling.MERGE) {
                for (ACE entry : this.aceList) {
                    for (AccessControlEntry ace : acl.getAccessControlEntries()) {
                        if (!ace.getPrincipal().getName().equals(entry.principalName)) continue;
                        acl.removeAccessControlEntry(ace);
                    }
                }
            }
            for (ACE ace : this.aceList) {
                String principalName = ace.principalName;
                if (JackrabbitACLImporter.this.aclHandling == AccessControlHandling.MERGE_PRESERVE && existingPrincipals.contains(principalName)) continue;
                Principal principal = this.getPrincipal(principalName);
                Privilege[] privileges = new Privilege[ace.privileges.length];
                for (int i = 0; i < privileges.length; ++i) {
                    privileges[i] = JackrabbitACLImporter.this.acMgr.privilegeFromName(ace.privileges[i]);
                }
                HashMap<String, Value> svRestrictions = new HashMap<String, Value>();
                HashMap<String, Value[]> mvRestrictions = new HashMap<String, Value[]>();
                for (String restName : acl.getRestrictionNames()) {
                    DocViewProperty restriction = (DocViewProperty)ace.restrictions.get(restName);
                    if (restriction == null) continue;
                    Value[] values = new Value[restriction.values.length];
                    int type = acl.getRestrictionType(restName);
                    for (int i = 0; i < values.length; ++i) {
                        values[i] = valueFactory.createValue(restriction.values[i], type);
                    }
                    if (restriction.isMulti) {
                        mvRestrictions.put(restName, values);
                        continue;
                    }
                    svRestrictions.put(restName, values[0]);
                }
                acl.addEntry(principal, privileges, ace.allow, svRestrictions, mvRestrictions);
            }
            JackrabbitACLImporter.this.acMgr.setPolicy(JackrabbitACLImporter.this.accessControlledPath, (AccessControlPolicy)acl);
            if (JackrabbitACLImporter.this.accessControlledPath == null) {
                JackrabbitACLImporter.this.addPathIfExists(paths, "/rep:repoPolicy");
            } else if ("/".equals(JackrabbitACLImporter.this.accessControlledPath)) {
                JackrabbitACLImporter.this.addPathIfExists(paths, "/rep:policy");
            } else {
                JackrabbitACLImporter.this.addPathIfExists(paths, JackrabbitACLImporter.this.accessControlledPath + "/rep:policy");
            }
        }
    }

    private abstract class ImportedPolicy<T extends AccessControlPolicy> {
        private ImportedPolicy() {
        }

        abstract State append(State var1, DocViewNode var2);

        abstract void endNode(State var1);

        abstract void apply(List<String> var1) throws RepositoryException;

        Principal getPrincipal(final String principalName) {
            Principal principal = new Principal(){

                @Override
                public String getName() {
                    return principalName;
                }
            };
            return principal;
        }

        T getPolicy(Class<T> clz) throws RepositoryException {
            for (AccessControlPolicy p : JackrabbitACLImporter.this.acMgr.getPolicies(JackrabbitACLImporter.this.accessControlledPath)) {
                if (!clz.isAssignableFrom(p.getClass())) continue;
                return (T)p;
            }
            return null;
        }

        T getApplicablePolicy(Class<T> clz) throws RepositoryException {
            AccessControlPolicyIterator iter = JackrabbitACLImporter.this.acMgr.getApplicablePolicies(JackrabbitACLImporter.this.accessControlledPath);
            while (iter.hasNext()) {
                AccessControlPolicy p = iter.nextAccessControlPolicy();
                if (!clz.isAssignableFrom(p.getClass())) continue;
                return (T)p;
            }
            throw new RepositoryException("no applicable AccessControlPolicy of type " + clz + " on " + (JackrabbitACLImporter.this.accessControlledPath == null ? "'root'" : JackrabbitACLImporter.this.accessControlledPath));
        }
    }

    private static enum State {
        INITIAL,
        ACL,
        ACE,
        RESTRICTION,
        ERROR,
        PRINCIPAL_SET_POLICY;

    }
}

