/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.jackrabbit.vault.fs.filter;

import javax.jcr.Item;
import javax.jcr.RepositoryException;
import shaded.org.apache.jackrabbit.vault.fs.api.DumpContext;
import shaded.org.apache.jackrabbit.vault.fs.api.ItemFilter;

public class DepthItemFilter
implements ItemFilter {
    private int minDepth = 0;
    private int maxDepth = Integer.MAX_VALUE;

    public DepthItemFilter() {
    }

    public DepthItemFilter(int minDepth, int maxDepth) {
        this.minDepth = minDepth;
        this.maxDepth = maxDepth;
    }

    public void setMinDepth(String minDepth) {
        this.minDepth = Integer.decode(minDepth);
    }

    public void setMaxDepth(String maxDepth) {
        this.maxDepth = Integer.decode(maxDepth);
    }

    @Override
    public boolean matches(Item item, int depth) throws RepositoryException {
        return depth >= this.minDepth && depth <= this.maxDepth && this.matches(item);
    }

    public boolean matches(Item item) throws RepositoryException {
        return true;
    }

    @Override
    public void dump(DumpContext ctx, boolean isLast) {
        ctx.printf(isLast, "%s:", this.getClass().getSimpleName());
        ctx.indent(isLast);
        ctx.printf(false, "minDepth: %d", this.minDepth);
        ctx.printf(true, "maxDepth: %d", this.maxDepth);
        ctx.outdent();
    }
}

