/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.jackrabbit.vault.fs.config;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;
import shaded.org.apache.commons.io.FileUtils;
import shaded.org.apache.commons.io.IOUtils;
import shaded.org.apache.jackrabbit.vault.fs.config.ConfigurationException;
import shaded.org.apache.jackrabbit.vault.util.RejectingEntityResolver;
import shaded.org.apache.jackrabbit.vault.util.xml.serialize.OutputFormat;
import shaded.org.apache.jackrabbit.vault.util.xml.serialize.XMLSerializer;

public abstract class AbstractConfig {
    protected static Logger log = LoggerFactory.getLogger(AbstractConfig.class);
    public static final String DIR_NAME = ".vault";
    public static final String ATTR_VERSION = "version";
    protected double version = this.getSupportedVersion();

    protected abstract String getRootElemName();

    protected abstract double getSupportedVersion();

    protected void load(Element doc) throws ConfigurationException {
        if (!doc.getNodeName().equals(this.getRootElemName())) {
            throw new ConfigurationException("unexpected element: " + doc.getNodeName());
        }
        String v = doc.getAttribute(ATTR_VERSION);
        if (v == null || v.equals("")) {
            v = "1.0";
        }
        this.version = Double.parseDouble(v);
        if (this.version > this.getSupportedVersion()) {
            throw new ConfigurationException("version " + this.version + " not supported.");
        }
        NodeList nl = doc.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            Node child = nl.item(i);
            if (child.getNodeType() != 1) continue;
            this.doLoad((Element)child);
        }
    }

    protected abstract void doLoad(Element var1) throws ConfigurationException;

    public boolean load(File configFile) throws IOException, ConfigurationException {
        return configFile.canRead() && this.load(FileUtils.openInputStream(configFile));
    }

    public boolean load(InputStream in) throws IOException, ConfigurationException {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            builder.setEntityResolver(new RejectingEntityResolver());
            Document document = builder.parse(in);
            Element doc = document.getDocumentElement();
            this.load(doc);
            boolean bl = true;
            return bl;
        }
        catch (ParserConfigurationException e) {
            throw new ConfigurationException(e);
        }
        catch (SAXException e) {
            throw new ConfigurationException(e);
        }
        finally {
            IOUtils.closeQuietly(in);
        }
    }

    public void save(File configFile) throws IOException {
        this.save(FileUtils.openOutputStream(configFile));
    }

    public void save(OutputStream out) throws IOException {
        OutputFormat fmt = new OutputFormat("xml", "UTF-8", true);
        fmt.setLineWidth(0);
        fmt.setIndent(2);
        XMLSerializer ser = new XMLSerializer(out, fmt);
        try {
            this.write(ser);
        }
        catch (SAXException e) {
            throw new IOException(e.toString());
        }
        finally {
            IOUtils.closeQuietly(out);
        }
    }

    public File getConfigDir() throws IOException {
        File userHome = new File(System.getProperty("user.home"));
        File configDir = new File(userHome, DIR_NAME);
        if (!configDir.exists()) {
            configDir.mkdirs();
            if (!configDir.exists()) {
                throw new IOException("Error: Unable to create " + configDir.getAbsolutePath());
            }
        }
        return configDir;
    }

    protected void write(ContentHandler handler) throws SAXException {
        handler.startDocument();
        AttributesImpl attrs = new AttributesImpl();
        attrs.addAttribute("", ATTR_VERSION, "", "CDATA", String.valueOf(this.version));
        handler.startElement("", this.getRootElemName(), "", attrs);
        this.doWrite(handler);
        handler.endElement("", this.getRootElemName(), "");
        handler.endDocument();
    }

    protected abstract void doWrite(ContentHandler var1) throws SAXException;
}

