/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.jackrabbit.vault.fs;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.jcr.RepositoryException;
import shaded.org.apache.commons.io.output.DeferredFileOutputStream;
import shaded.org.apache.jackrabbit.vault.fs.api.AccessType;
import shaded.org.apache.jackrabbit.vault.fs.api.Artifact;
import shaded.org.apache.jackrabbit.vault.fs.api.ArtifactType;
import shaded.org.apache.jackrabbit.vault.fs.api.ExportArtifact;
import shaded.org.apache.jackrabbit.vault.fs.api.SerializationType;
import shaded.org.apache.jackrabbit.vault.fs.api.VaultInputSource;
import shaded.org.apache.jackrabbit.vault.fs.impl.AbstractArtifact;
import shaded.org.apache.jackrabbit.vault.fs.io.Serializer;
import shaded.org.apache.jackrabbit.vault.util.TempFileInputStream;

public class SerializerArtifact
extends AbstractArtifact
implements ExportArtifact {
    private final Serializer serializer;
    private final long lastModified;

    public SerializerArtifact(Artifact parent, String name, String ext, ArtifactType type, Serializer serializer, long lastModified) {
        super(parent, name, ext, type);
        if (type == ArtifactType.DIRECTORY) {
            throw new IllegalArgumentException("Illegal type 'TYPE_DIRECTORY' for a serialized artifact.");
        }
        this.serializer = serializer;
        this.lastModified = lastModified;
    }

    @Override
    public AccessType getPreferredAccess() {
        return AccessType.SPOOL;
    }

    @Override
    public SerializationType getSerializationType() {
        return this.serializer.getType();
    }

    @Override
    public void spool(OutputStream out) throws IOException, RepositoryException {
        this.serializer.writeContent(out);
    }

    @Override
    public InputStream getInputStream() throws IOException, RepositoryException {
        DeferredFileOutputStream out = new DeferredFileOutputStream(8192, "vlttmp", ".tmp", null);
        this.spool(out);
        out.close();
        if (out.isInMemory()) {
            return new ByteArrayInputStream(out.getData());
        }
        return new TempFileInputStream(out.getFile());
    }

    @Override
    public VaultInputSource getInputSource() throws IOException, RepositoryException {
        long size;
        InputStream in;
        DeferredFileOutputStream out = new DeferredFileOutputStream(8192, "vlttmp", ".tmp", null);
        this.spool(out);
        out.close();
        if (out.isInMemory()) {
            in = new ByteArrayInputStream(out.getData());
            size = out.getData().length;
        } else {
            in = new TempFileInputStream(out.getFile());
            size = out.getFile().length();
        }
        return new VaultInputSource(){

            @Override
            public String getSystemId() {
                return SerializerArtifact.this.getRelativePath();
            }

            @Override
            public InputStream getByteStream() {
                return in;
            }

            @Override
            public long getContentLength() {
                return size;
            }

            @Override
            public long getLastModified() {
                return SerializerArtifact.this.lastModified;
            }
        };
    }

    @Override
    public String getContentType() {
        String ct = super.getContentType();
        if (ct == null) {
            ct = this.serializer.getType().getContentType();
        }
        return ct;
    }

    @Override
    public long getContentLength() {
        return -1L;
    }

    @Override
    public long getLastModified() {
        return this.lastModified;
    }
}

