/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.cpconverter.handlers.slinginitialcontent;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.jcr.NamespaceException;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.commons.conversion.NameResolver;
import org.apache.jackrabbit.spi.commons.name.NameConstants;
import org.apache.jackrabbit.spi.commons.namespace.NamespaceResolver;
import org.apache.jackrabbit.vault.util.DocViewNode2;
import org.apache.jackrabbit.vault.util.DocViewProperty2;

public class DocViewTreeNode {
    private final List<DocViewTreeNode> children = new LinkedList<DocViewTreeNode>();
    private final Name name;
    private final String parentPath;
    private final Collection<DocViewProperty2> properties;

    public DocViewTreeNode(String parentPath, Name name, Collection<DocViewProperty2> properties) {
        this.name = name;
        this.properties = properties;
        this.parentPath = parentPath;
    }

    public void addChild(DocViewTreeNode child) {
        this.children.add(child);
    }

    void write(XMLStreamWriter writer, NamespaceResolver nsResolver) throws NamespaceException, XMLStreamException {
        this.write(writer, nsResolver, Collections.emptyList());
    }

    public void write(XMLStreamWriter writer, NamespaceResolver nsResolver, Iterable<String> nsPrefixes) throws NamespaceException, XMLStreamException {
        DocViewNode2 docViewNode = new DocViewNode2(this.name, this.properties);
        docViewNode.writeStart(writer, nsResolver, nsPrefixes);
        for (DocViewTreeNode child : this.children) {
            child.write(writer, nsResolver);
        }
        DocViewNode2.writeEnd((XMLStreamWriter)writer);
    }

    public Collection<DocViewProperty2> getProperties() {
        return this.properties;
    }

    public String getPath(NameResolver nameResolver) throws NamespaceException {
        if (NameConstants.JCR_ROOT.equals((Object)this.name)) {
            return this.parentPath;
        }
        return this.parentPath + "/" + nameResolver.getJCRName(this.name);
    }
}

