/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.cpconverter.handlers.slinginitialcontent;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.commons.cnd.ParseException;
import org.apache.sling.commons.osgi.ManifestHeader;
import org.apache.sling.feature.cpconverter.vltpkg.JcrNamespaceRegistry;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class JcrNamespaceRegistryProvider {
    public static final String NODETYPES_BUNDLE_HEADER = "Sling-Nodetypes";
    public static final String NAMESPACES_BUNDLE_HEADER = "Sling-Namespaces";
    private static final Logger logger = LoggerFactory.getLogger(JcrNamespaceRegistryProvider.class);
    private final Manifest manifest;
    private final JarFile jarFile;
    private final Map<String, String> predefinedNamespaceUriByPrefix;

    JcrNamespaceRegistryProvider(@NotNull Manifest manifest, @NotNull JarFile jarFile, @NotNull Map<String, String> predefinedNamespaceUriByPrefix) {
        this.manifest = manifest;
        this.jarFile = jarFile;
        this.predefinedNamespaceUriByPrefix = predefinedNamespaceUriByPrefix;
    }

    @NotNull
    JcrNamespaceRegistry provideRegistryFromBundle() throws IOException {
        try {
            String typesHeader;
            JcrNamespaceRegistry registry = new JcrNamespaceRegistry();
            for (Map.Entry<String, String> entry : this.predefinedNamespaceUriByPrefix.entrySet()) {
                registry.registerNamespace(entry.getKey(), entry.getValue());
            }
            String namespacesDefinitionHeader = this.manifest.getMainAttributes().getValue(NAMESPACES_BUNDLE_HEADER);
            if (namespacesDefinitionHeader != null) {
                this.registerNamespacesIntoRegistry(registry, namespacesDefinitionHeader);
            }
            if ((typesHeader = this.manifest.getMainAttributes().getValue(NODETYPES_BUNDLE_HEADER)) != null) {
                this.registerCndIntoRegistry(registry, typesHeader);
            }
            return registry;
        }
        catch (RepositoryException | ParseException e) {
            throw new IOException(e.getMessage(), e);
        }
    }

    private void registerNamespacesIntoRegistry(@NotNull JcrNamespaceRegistry registry, @NotNull String namespacesDefinitionHeader) throws RepositoryException {
        StringTokenizer st = new StringTokenizer(namespacesDefinitionHeader, ",");
        while (st.hasMoreTokens()) {
            String token = st.nextToken().trim();
            int pos = token.indexOf(61);
            if (pos == -1) {
                logger.warn("createNamespaceRegistry: Bundle {} has an invalid namespace manifest header entry: {}", (Object)this.manifest.getMainAttributes().getValue("Bundle-SymbolicName"), (Object)token);
                continue;
            }
            String prefix = token.substring(0, pos).trim();
            String namespace = token.substring(pos + 1).trim();
            registry.registerNamespace(prefix, namespace);
        }
    }

    private void registerCndIntoRegistry(@NotNull JcrNamespaceRegistry registry, @NotNull String typesHeader) throws IOException, ParseException, RepositoryException {
        for (ManifestHeader.Entry entry : ManifestHeader.parse((String)typesHeader).getEntries()) {
            JarEntry jarEntry = this.jarFile.getJarEntry(entry.getValue());
            if (jarEntry == null) {
                logger.warn("createNamespaceRegistry: Bundle {} has referenced a non existing node type definition: {}", (Object)this.manifest.getMainAttributes().getValue("Bundle-SymbolicName"), (Object)entry.getValue());
                continue;
            }
            try (InputStream inputStream = this.jarFile.getInputStream(jarEntry);
                 InputStreamReader reader = new InputStreamReader(inputStream, StandardCharsets.UTF_8);){
                registry.registerCnd(reader, entry.getValue());
            }
        }
    }
}

