/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements. See the NOTICE file distributed with this
 * work for additional information regarding copyright ownership. The ASF
 * licenses this file to You under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package org.apache.sling.feature.cpconverter.accesscontrol;

import org.apache.sling.feature.cpconverter.shared.RepoPath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SystemUser extends AbstractUser {

    /**
     * @param id - the authorizableId to use.
     * @param path - the original repository path of the user in the content-package.
     * @param intermediatePath - the intermediate path the user should have - most likely the (direct) parent of the path.
     */
    public SystemUser(@NotNull String id, @NotNull RepoPath path, @NotNull RepoPath intermediatePath) {
        super(id, path, intermediatePath);
    }

    /**
     * @param id - the authorizableId to use.
     * @param path - the original repository path of the user in the content-package.
     * @param intermediatePath - the intermediate path the user should have - most likely the (direct) parent of the path.
     * @param disabledReason - the reason why this user has been disabled or {@code null}.
     */
    public SystemUser(@NotNull String id, @NotNull RepoPath path, @NotNull RepoPath intermediatePath, @Nullable String disabledReason) {
        super(id, path, intermediatePath, disabledReason);
    }
}
