/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.peaberry.internal;

import java.lang.reflect.Constructor;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.concurrent.ConcurrentMap;
import org.ops4j.peaberry.Import;
import org.ops4j.peaberry.ServiceException;
import org.ops4j.peaberry.ServiceUnavailableException;
import org.ops4j.peaberry.internal.ComputedMapFactory;
import org.ops4j.peaberry.internal.ConcurrentReferenceHashMap;
import org.ops4j.peaberry.internal.ImportGlue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ImportProxyClassLoader
extends ClassLoader {
    private static final String UNAVAILABLE_CLAZZ_NAME = ServiceUnavailableException.class.getName();
    private static final String IMPORT_CLAZZ_NAME = Import.class.getName();
    private static final Object NULL_CLASS_LOADER_KEY = new Object();
    private static final ConcurrentMap<Object, ClassLoader> LOADER_MAP = ComputedMapFactory.computedMap(ConcurrentReferenceHashMap.ReferenceType.WEAK, ConcurrentReferenceHashMap.ReferenceType.WEAK, 32, new ComputedMapFactory.Function<Object, ClassLoader>(){

        @Override
        public ClassLoader compute(final Object parentKey) {
            return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

                @Override
                public ClassLoader run() {
                    return new ImportProxyClassLoader(ImportProxyClassLoader.getClassLoaderFromKey(parentKey));
                }
            });
        }
    });

    static <T> Constructor<T> getProxyConstructor(Class<T> clazz) {
        try {
            return ImportProxyClassLoader.getProxyClass(clazz).getConstructor(Import.class);
        }
        catch (LinkageError e) {
            throw new ServiceException(e);
        }
        catch (NoSuchMethodException e) {
            throw new ServiceException(e);
        }
        catch (ClassNotFoundException e) {
            throw new ServiceException(e);
        }
    }

    static Class<?> getProxyClass(Class<?> clazz) throws ClassNotFoundException {
        Object key = ImportProxyClassLoader.getKeyFromClassLoader(clazz.getClassLoader());
        String name = ImportGlue.getProxyName(clazz.getName());
        return ((ClassLoader)LOADER_MAP.get(key)).loadClass(name);
    }

    static Object getKeyFromClassLoader(ClassLoader classLoader) {
        if (null != classLoader) {
            return classLoader;
        }
        try {
            return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

                @Override
                public ClassLoader run() {
                    return ClassLoader.getSystemClassLoader();
                }
            });
        }
        catch (SecurityException e) {
            return NULL_CLASS_LOADER_KEY;
        }
    }

    static ClassLoader getClassLoaderFromKey(Object key) {
        return NULL_CLASS_LOADER_KEY != key ? (ClassLoader)key : null;
    }

    ImportProxyClassLoader(ClassLoader parent) {
        super(parent);
    }

    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        if (IMPORT_CLAZZ_NAME.equals(name)) {
            return Import.class;
        }
        if (UNAVAILABLE_CLAZZ_NAME.equals(name)) {
            return ServiceUnavailableException.class;
        }
        return super.loadClass(name, resolve);
    }

    @Override
    protected Class<?> findClass(String clazzOrProxyName) throws ClassNotFoundException {
        String clazzName = ImportGlue.getClazzName(clazzOrProxyName);
        if (!clazzName.equals(clazzOrProxyName)) {
            byte[] code = ImportGlue.generateProxy(this.loadClass(clazzName));
            return this.defineClass(clazzOrProxyName, code, 0, code.length);
        }
        throw new ClassNotFoundException(clazzOrProxyName);
    }
}

