/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.handler.link.impl;

import com.day.cq.wcm.api.Page;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.wcm.handler.link.Link;
import io.wcm.handler.link.LinkArgs;
import io.wcm.handler.link.LinkBuilder;
import io.wcm.handler.link.LinkHandler;
import io.wcm.handler.link.LinkRequest;
import io.wcm.handler.link.impl.LinkBuilderImpl;
import io.wcm.handler.link.spi.LinkHandlerConfig;
import io.wcm.handler.link.spi.LinkMarkupBuilder;
import io.wcm.handler.link.spi.LinkProcessor;
import io.wcm.handler.link.spi.LinkType;
import io.wcm.sling.commons.adapter.AdaptTo;
import io.wcm.sling.models.annotations.AemObject;
import io.wcm.wcm.commons.component.ComponentPropertyResolverFactory;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.adapter.Adaptable;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.models.annotations.Model;
import org.apache.sling.models.annotations.injectorspecific.InjectionStrategy;
import org.apache.sling.models.annotations.injectorspecific.OSGiService;
import org.apache.sling.models.annotations.injectorspecific.Self;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Model(adaptables={SlingHttpServletRequest.class, Resource.class}, adapters={LinkHandler.class})
public final class LinkHandlerImpl
implements LinkHandler {
    @Self
    private Adaptable adaptable;
    @Self
    private LinkHandlerConfig linkHandlerConfig;
    @AemObject(injectionStrategy=InjectionStrategy.OPTIONAL)
    private Page currentPage;
    @OSGiService(injectionStrategy=InjectionStrategy.OPTIONAL)
    private ComponentPropertyResolverFactory componentPropertyResolverFactory;

    @Override
    @NotNull
    public LinkBuilder get(Resource resource) {
        return new LinkBuilderImpl(resource, this, this.componentPropertyResolverFactory);
    }

    @Override
    @NotNull
    public LinkBuilder get(Page page) {
        return new LinkBuilderImpl(page, this);
    }

    @Override
    @NotNull
    public LinkBuilder get(String reference) {
        return new LinkBuilderImpl(reference, this);
    }

    @Override
    @NotNull
    public LinkBuilder get(@NotNull LinkRequest linkRequest) {
        return new LinkBuilderImpl(linkRequest, this);
    }

    @NotNull
    @SuppressFBWarnings(value={"CORRECTNESS", "STYLE"})
    Link processRequest(@NotNull LinkRequest linkRequest) {
        List<Class<? extends LinkProcessor>> list;
        Link link;
        LinkRequest fallbackLinkRequest;
        LinkType linkType = null;
        List<Class<? extends LinkType>> linkTypes = this.linkHandlerConfig.getLinkTypes();
        if (linkTypes == null || linkTypes.isEmpty()) {
            throw new RuntimeException("No link types defined.");
        }
        for (Class<? extends LinkType> candidateLinkTypeClass : linkTypes) {
            LinkType candidateLinkType = (LinkType)AdaptTo.notNull((Adaptable)this.adaptable, candidateLinkTypeClass);
            if (!candidateLinkType.accepts(linkRequest)) continue;
            linkType = candidateLinkType;
            break;
        }
        Link link2 = new Link(linkType, linkRequest);
        List<Class<? extends LinkProcessor>> linkPreProcessors = this.linkHandlerConfig.getPreProcessors();
        if (linkPreProcessors != null) {
            for (Class clazz : linkPreProcessors) {
                LinkProcessor linkProcessor = (LinkProcessor)AdaptTo.notNull((Adaptable)this.adaptable, (Class)clazz);
                link2 = linkProcessor.process(link2);
                if (link2 != null) continue;
                throw new RuntimeException("LinkPreProcessor '" + linkProcessor + "' returned null, page '" + (this.currentPage != null ? this.currentPage.getPath() : "-") + "'.");
            }
        }
        if (linkType != null && (link2 = linkType.resolveLink(link2)) == null) {
            throw new RuntimeException("LinkType '" + linkType + "' returned null, page '" + (this.currentPage != null ? this.currentPage.getPath() : "-") + "'.");
        }
        if (!link2.isValid() && (fallbackLinkRequest = this.getFallbackLinkRequest(linkRequest)) != null && (link = this.processRequest(fallbackLinkRequest)).isValid()) {
            return link;
        }
        List<Class<? extends LinkMarkupBuilder>> linkMarkupBuilders = this.linkHandlerConfig.getMarkupBuilders();
        if (linkMarkupBuilders != null) {
            for (Class<? extends LinkMarkupBuilder> clazz : linkMarkupBuilders) {
                LinkMarkupBuilder linkMarkupBuilder = (LinkMarkupBuilder)AdaptTo.notNull((Adaptable)this.adaptable, clazz);
                if (!linkMarkupBuilder.accepts(link2)) continue;
                link2.setAnchor(linkMarkupBuilder.build(link2));
                break;
            }
        }
        if ((list = this.linkHandlerConfig.getPostProcessors()) != null) {
            for (Class<? extends LinkProcessor> processorClass : list) {
                LinkProcessor processor = (LinkProcessor)AdaptTo.notNull((Adaptable)this.adaptable, processorClass);
                link2 = processor.process(link2);
                if (link2 != null) continue;
                throw new RuntimeException("LinkPostProcessor '" + processor + "' returned null, page '" + (this.currentPage != null ? this.currentPage.getPath() : "-") + "'.");
            }
        }
        return link2;
    }

    @Override
    public Link invalid() {
        Class linkTypeClass = this.linkHandlerConfig.getLinkTypes().stream().findFirst().orElse(null);
        if (linkTypeClass == null) {
            throw new RuntimeException("No link types defined.");
        }
        LinkType linkType = (LinkType)AdaptTo.notNull((Adaptable)this.adaptable, (Class)linkTypeClass);
        return new Link(linkType, new LinkRequest(null, null, null));
    }

    @Nullable
    private LinkRequest getFallbackLinkRequest(@NotNull LinkRequest linkRequest) {
        Resource resource = linkRequest.getResource();
        if (resource == null) {
            return null;
        }
        String[] linkTargetUrlFallbackProperty = linkRequest.getLinkArgs().getLinkTargetUrlFallbackProperty();
        if (linkTargetUrlFallbackProperty == null || linkTargetUrlFallbackProperty.length == 0) {
            return null;
        }
        String linkTargetUrl = null;
        for (String propertyName : linkTargetUrlFallbackProperty) {
            linkTargetUrl = (String)resource.getValueMap().get(propertyName, String.class);
            if (StringUtils.isNotBlank((CharSequence)linkTargetUrl)) break;
        }
        if (StringUtils.isBlank(linkTargetUrl)) {
            return null;
        }
        LinkArgs fallbackLinkArgs = linkRequest.getLinkArgs().clone();
        String[] nullArray = null;
        fallbackLinkArgs.linkTargetUrlFallbackProperty(nullArray);
        return new LinkRequest(null, null, linkTargetUrl, fallbackLinkArgs);
    }
}

